/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionConverter;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerLogger;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerRemoteProcessSupport;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenServerConnectorImpl
implements MavenServerConnector {
    private final RemoteMavenServerLogger myLogger;
    private final RemoteMavenServerDownloadListener myDownloadListener;
    private final Project myProject;
    private final MavenServerManager myManager;
    private final Integer myDebugPort;
    private boolean myLoggerExported;
    private boolean myDownloadListenerExported;
    private final Sdk myJdk;
    private final MavenDistribution myDistribution;
    private final String myVmOptions;
    private MavenServerRemoteProcessSupport mySupport;
    private MavenServer myMavenServer;

    public MavenServerConnectorImpl(@NotNull Project project, @NotNull MavenServerManager manager, @NotNull MavenWorkspaceSettings settings, @NotNull Sdk jdk, @Nullable Integer debugPort) {
        if (project == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(2);
        }
        if (jdk == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(3);
        }
        this.myLogger = new RemoteMavenServerLogger();
        this.myDownloadListener = new RemoteMavenServerDownloadListener();
        this.myProject = project;
        this.myManager = manager;
        this.myDebugPort = debugPort;
        this.myDistribution = MavenServerConnectorImpl.findMavenDistribution(project, settings);
        settings.generalSettings.setMavenHome(this.myDistribution.getMavenHome().getAbsolutePath());
        this.myVmOptions = MavenServerConnectorImpl.readVmOptions(project, settings);
        this.myJdk = jdk;
        this.connect();
    }

    public MavenServerConnectorImpl(@NotNull Project project, @NotNull MavenServerManager manager, @NotNull MavenWorkspaceSettings settings, @NotNull Sdk jdk) {
        if (project == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(6);
        }
        if (jdk == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(7);
        }
        this(project, manager, settings, jdk, null);
    }

    @Override
    public boolean isSettingsStillValid(MavenWorkspaceSettings settings) {
        String baseDir = this.myProject.getBasePath();
        if (baseDir == null) {
            return true;
        }
        String distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(LocalFileSystem.getInstance().findFileByPath(baseDir));
        if (distributionUrl != null && !distributionUrl.equals(this.myDistribution.getName())) {
            return false;
        }
        String newVmOptions = MavenServerConnectorImpl.readVmOptions(this.myProject, settings);
        return StringUtil.equals((CharSequence)newVmOptions, (CharSequence)this.myVmOptions);
    }

    private static String readVmOptions(Project project, MavenWorkspaceSettings settings) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return settings.importingSettings.getVmOptionsForImporter();
        }
        VirtualFile mvn = baseDir.findChild(".mvn");
        if (mvn == null) {
            return settings.importingSettings.getVmOptionsForImporter();
        }
        VirtualFile jdkOpts = mvn.findChild("jvm.config");
        if (jdkOpts == null) {
            return settings.importingSettings.getVmOptionsForImporter();
        }
        try {
            return new String(jdkOpts.contentsToByteArray(true), CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
            return settings.importingSettings.getVmOptionsForImporter();
        }
    }

    @Nullable
    private static String getWrapperDistributionUrl(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        return MavenWrapperSupport.getWrapperDistributionUrl(baseDir);
    }

    private static MavenDistribution findMavenDistribution(Project project, MavenWorkspaceSettings settings) {
        MavenSyncConsole console = MavenProjectsManager.getInstance(project).getSyncConsole();
        String distributionUrl = MavenServerConnectorImpl.getWrapperDistributionUrl(project);
        if (distributionUrl == null) {
            MavenDistribution distribution = new MavenDistributionConverter().fromString(settings.generalSettings.getMavenHome());
            if (distribution == null) {
                console.addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.generalSettings.getMavenHome()));
                return MavenServerManager.resolveEmbeddedMavenHome();
            }
            return distribution;
        }
        try {
            console.startWrapperResolving();
            MavenDistribution distribution = new MavenWrapperSupport().downloadAndInstallMaven(distributionUrl, console.progressIndicatorForWrapper());
            console.finishWrapperResolving(null);
            return distribution;
        }
        catch (IOException | RuntimeException e) {
            MavenLog.LOG.info((Throwable)e);
            console.finishWrapperResolving(e);
            return MavenServerManager.resolveEmbeddedMavenHome();
        }
    }

    private void connect() {
        if (this.mySupport != null || this.myMavenServer != null) {
            throw new IllegalStateException("Already connected");
        }
        try {
            if (this.myDebugPort != null) {
                System.out.println("Listening for transport dt_socket at address: " + this.myDebugPort);
            }
            this.mySupport = new MavenServerRemoteProcessSupport(this.myJdk, this.myVmOptions, this.myDistribution, this.myProject, this.myDebugPort);
            this.myMavenServer = (MavenServer)this.mySupport.acquire(this, "");
            boolean bl = this.myLoggerExported = MavenRemoteObjectWrapper.doWrapAndExport(this.myLogger) != null;
            if (!this.myLoggerExported) {
                throw new RemoteException("Cannot export logger object");
            }
            boolean bl2 = this.myDownloadListenerExported = MavenRemoteObjectWrapper.doWrapAndExport(this.myDownloadListener) != null;
            if (!this.myDownloadListenerExported) {
                throw new RemoteException("Cannot export download listener object");
            }
            this.myMavenServer.set((MavenServerLogger)this.myLogger, (MavenServerDownloadListener)this.myDownloadListener, MavenRemoteObjectWrapper.ourToken);
        }
        catch (Exception e) {
            throw new CannotStartServerException(e);
        }
    }

    private void cleanUp() {
        if (this.myLoggerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myLogger), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
            this.myLoggerExported = false;
        }
        if (this.myDownloadListenerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myDownloadListener), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
            this.myDownloadListenerExported = false;
        }
        this.myMavenServer = null;
        this.mySupport = null;
    }

    @Override
    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings) throws RemoteException {
        return this.myMavenServer.createEmbedder(settings, MavenRemoteObjectWrapper.ourToken);
    }

    @Override
    public MavenServerIndexer createIndexer() throws RemoteException {
        return this.myMavenServer.createIndexer(MavenRemoteObjectWrapper.ourToken);
    }

    @Override
    public void addDownloadListener(MavenServerDownloadListener listener2) {
        this.myDownloadListener.myListeners.add(listener2);
    }

    @Override
    public void removeDownloadListener(MavenServerDownloadListener listener2) {
        this.myDownloadListener.myListeners.remove(listener2);
    }

    @Override
    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel model2, File basedir) {
        MavenModel mavenModel = this.perform(() -> this.myMavenServer.interpolateAndAlignModel(model2, basedir, MavenRemoteObjectWrapper.ourToken));
        if (mavenModel == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(8);
        }
        return mavenModel;
    }

    @Override
    public MavenModel assembleInheritance(MavenModel model2, MavenModel parentModel) {
        return this.perform(() -> this.myMavenServer.assembleInheritance(model2, parentModel, MavenRemoteObjectWrapper.ourToken));
    }

    @Override
    public ProfileApplicationResult applyProfiles(MavenModel model2, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return this.perform(() -> this.myMavenServer.applyProfiles(model2, basedir, explicitProfiles, alwaysOnProfiles, MavenRemoteObjectWrapper.ourToken));
    }

    @Override
    public void shutdown(boolean wait) {
        this.myManager.unregisterConnector(this);
        if (this.mySupport != null) {
            this.mySupport.stopAll(wait);
        }
        this.cleanUp();
    }

    @Override
    public <R, E extends Exception> R perform(RemoteObjectWrapper.Retriable<R, E> r) throws E {
        Throwable last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                MavenServerRemoteProcessSupport processSupport = this.mySupport;
                if (processSupport != null) {
                    processSupport.stopAll(false);
                }
                this.cleanUp();
                this.connect();
                continue;
            }
        }
        throw new RuntimeException("Cannot reconnect.", last);
    }

    @Override
    public void dispose() {
        this.shutdown(true);
    }

    @Override
    @NotNull
    public Sdk getJdk() {
        Sdk sdk = this.myJdk;
        if (sdk == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(9);
        }
        return sdk;
    }

    @Override
    public MavenDistribution getMavenDistribution() {
        return this.myDistribution;
    }

    @Override
    public String getVMOptions() {
        return this.myVmOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerConnectorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerConnectorImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteMavenServerDownloadListener
    extends MavenRemoteObject
    implements MavenServerDownloadListener {
        private final List<MavenServerDownloadListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private RemoteMavenServerDownloadListener() {
        }

        public void artifactDownloaded(File file, String relativePath) throws RemoteException {
            for (MavenServerDownloadListener each : this.myListeners) {
                each.artifactDownloaded(file, relativePath);
            }
        }
    }

    private static class RemoteMavenServerLogger
    extends MavenRemoteObject
    implements MavenServerLogger {
        private RemoteMavenServerLogger() {
        }

        public void info(Throwable e) {
            MavenLog.LOG.info(e);
        }

        public void warn(Throwable e) {
            MavenLog.LOG.warn(e);
        }

        public void error(Throwable e) {
            MavenLog.LOG.error(e);
        }

        public void print(String s) {
            System.out.println(s);
        }
    }
}

