/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenCoordinate;

public class MavenId
implements Serializable,
MavenCoordinate {
    public static final String UNKNOWN_VALUE = "Unknown";
    @Nullable
    private final String myGroupId;
    @Nullable
    private final String myArtifactId;
    @Nullable
    private final String myVersion;

    public MavenId(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
    }

    public MavenId(@Nullable String coord) {
        if (coord == null) {
            this.myVersion = null;
            this.myArtifactId = null;
            this.myGroupId = null;
        } else {
            String[] parts = coord.split(":");
            this.myGroupId = parts.length > 0 ? parts[0] : null;
            this.myArtifactId = parts.length > 1 ? parts[1] : null;
            this.myVersion = parts.length > 2 ? parts[2] : null;
        }
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    @NotNull
    public String getKey() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        String string = builder.toString();
        if (string == null) {
            MavenId.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayString() {
        String string = this.getKey();
        if (string == null) {
            MavenId.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void append(StringBuilder builder, String part) {
        if (builder.length() != 0) {
            builder.append(':');
        }
        builder.append(part == null ? "<unknown>" : part);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(@Nullable String groupId, @Nullable String artifactId) {
        if (this.myArtifactId != null ? !this.myArtifactId.equals(artifactId) : artifactId != null) {
            return false;
        }
        return !(this.myGroupId != null ? !this.myGroupId.equals(groupId) : groupId != null);
    }

    public boolean equals(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        if (!this.equals(groupId, artifactId)) {
            return false;
        }
        return !(this.myVersion != null ? !this.myVersion.equals(version) : version != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenId other = (MavenId)o;
        return this.equals(other.getGroupId(), other.myArtifactId, other.myVersion);
    }

    public int hashCode() {
        int result = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/model/MavenId";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

