/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public abstract class CreateClassActionBase
extends Intention {
    private final GrCreateClassKind myType;
    protected final GrReferenceElement myRefElement;
    private static final Logger LOG = Logger.getInstance(CreateClassActionBase.class);

    public CreateClassActionBase(GrCreateClassKind type2, GrReferenceElement refElement) {
        this.myType = type2;
        this.myRefElement = refElement;
    }

    @Override
    @NotNull
    public String getText() {
        String referenceName = this.myRefElement.getReferenceName();
        switch (this.getType()) {
            case TRAIT: {
                String string = GroovyBundle.message("create.trait", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(0);
                }
                return string;
            }
            case ENUM: {
                String string = GroovyBundle.message("create.enum", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(1);
                }
                return string;
            }
            case CLASS: {
                String string = GroovyBundle.message("create.class.text", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(2);
                }
                return string;
            }
            case INTERFACE: {
                String string = GroovyBundle.message("create.interface.text", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(3);
                }
                return string;
            }
            case ANNOTATION: {
                String string = GroovyBundle.message("create.annotation.text", referenceName);
                if (string == null) {
                    CreateClassActionBase.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        return "";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.class.family.name", new Object[0]);
        if (string == null) {
            CreateClassActionBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateClassActionBase.$$$reportNull$$$0(6);
        }
        return this.myRefElement.isValid() && ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRefElement) != null;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    protected GrCreateClassKind getType() {
        return this.myType;
    }

    @Nullable
    public static GrTypeDefinition createClassByType(@NotNull PsiDirectory directory, @NotNull String name, @NotNull PsiManager manager, @Nullable PsiElement contextElement, @NotNull String templateName, boolean allowReformatting) {
        if (directory == null) {
            CreateClassActionBase.$$$reportNull$$$0(7);
        }
        if (name == null) {
            CreateClassActionBase.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            CreateClassActionBase.$$$reportNull$$$0(9);
        }
        if (templateName == null) {
            CreateClassActionBase.$$$reportNull$$$0(10);
        }
        return (GrTypeDefinition)WriteAction.compute(() -> {
            try {
                GrTypeDefinition targetClass = null;
                try {
                    PsiFile file = GroovyTemplatesFactory.createFromTemplate(directory, name, name + ".groovy", templateName, allowReformatting, new String[0]);
                    for (PsiElement element : file.getChildren()) {
                        if (!(element instanceof GrTypeDefinition)) continue;
                        targetClass = (GrTypeDefinition)element;
                        break;
                    }
                    if (targetClass == null) {
                        throw new IncorrectOperationException(GroovyBundle.message("no.class.in.file.template", new Object[0]));
                    }
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)GroovyBundle.message("cannot.create.class.error.text", name, e.getLocalizedMessage()), (String)GroovyBundle.message("cannot.create.class.error.title", new Object[0])));
                    return null;
                }
                GrModifierList modifiers = targetClass.getModifierList();
                if (contextElement != null && !JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper().isAccessible((PsiMember)targetClass, contextElement, null) && modifiers != null) {
                    modifiers.setModifierProperty("public", true);
                }
                return targetClass;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(@NotNull Project project, @NotNull String qualifier, @NotNull String name, @Nullable Module module, @NlsContexts.DialogTitle @NotNull String title) {
        if (project == null) {
            CreateClassActionBase.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            CreateClassActionBase.$$$reportNull$$$0(12);
        }
        if (name == null) {
            CreateClassActionBase.$$$reportNull$$$0(13);
        }
        if (title == null) {
            CreateClassActionBase.$$$reportNull$$$0(14);
        }
        CreateClassDialog dialog = new CreateClassDialog(project, title, name, qualifier, this.getType(), false, module){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog.getTargetDirectory();
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return CreateClassActionBase.this.myRefElement.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase$2", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateClassActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createClassByType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

