/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAddImportAction
extends ImportClassFixBase<GrReferenceElement, GrReferenceElement> {
    private final GrReferenceElement<?> ref;

    public GroovyAddImportAction(@NotNull GrReferenceElement ref) {
        if (ref == null) {
            GroovyAddImportAction.$$$reportNull$$$0(0);
        }
        super((PsiElement)ref, (PsiReference)ref);
        this.ref = ref;
    }

    protected String getReferenceName(@NotNull GrReferenceElement reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(1);
        }
        return reference.getReferenceName();
    }

    protected PsiElement getReferenceNameElement(@NotNull GrReferenceElement reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(2);
        }
        return reference.getReferenceNameElement();
    }

    protected boolean hasTypeParameters(@NotNull GrReferenceElement reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(3);
        }
        return reference.getTypeArguments().length > 0;
    }

    protected String getQualifiedName(@NotNull GrReferenceElement reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(4);
        }
        return reference.getCanonicalText();
    }

    protected boolean isQualified(@NotNull GrReferenceElement reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(5);
        }
        return reference.getQualifier() != null;
    }

    protected boolean hasUnresolvedImportWhichCanImport(PsiFile psiFile, String name) {
        GrImportStatement[] importStatements;
        if (!(psiFile instanceof GroovyFile)) {
            return false;
        }
        for (GrImportStatement importStatement : importStatements = ((GroovyFile)psiFile).getImportStatements()) {
            GrCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null || importReference.resolve() != null || !importStatement.isOnDemand() && !Comparing.strEqual((String)importStatement.getImportedName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull GrReferenceElement ref) {
        PsiElement typeElement;
        if (candidates == null) {
            GroovyAddImportAction.$$$reportNull$$$0(6);
        }
        if (ref == null) {
            GroovyAddImportAction.$$$reportNull$$$0(7);
        }
        if ((typeElement = ref.getParent()) instanceof GrTypeElement) {
            PsiType type2;
            PsiExpression initializer;
            GrVariable[] vars;
            PsiElement decl = typeElement.getParent();
            if (decl instanceof GrVariableDeclaration && (vars = ((GrVariableDeclaration)decl).getVariables()).length == 1 && (initializer = vars[0].getInitializer()) != null && (type2 = initializer.getType()) != null) {
                List list = GroovyAddImportAction.filterAssignableFrom((PsiType)type2, candidates);
                if (list == null) {
                    GroovyAddImportAction.$$$reportNull$$$0(8);
                }
                return list;
            }
            if (decl instanceof GrParameter) {
                List list = GroovyAddImportAction.filterBySuperMethods((PsiParameter)((PsiParameter)decl), candidates);
                if (list == null) {
                    GroovyAddImportAction.$$$reportNull$$$0(9);
                }
                return list;
            }
        }
        List list = super.filterByContext(candidates, (PsiElement)ref);
        if (list == null) {
            GroovyAddImportAction.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected String getRequiredMemberName(@NotNull GrReferenceElement reference) {
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(11);
        }
        if (reference.getParent() instanceof GrReferenceElement) {
            return ((GrReferenceElement)reference.getParent()).getReferenceName();
        }
        return super.getRequiredMemberName((PsiElement)reference);
    }

    protected boolean isAccessible(@NotNull PsiMember member, @NotNull GrReferenceElement reference) {
        if (member == null) {
            GroovyAddImportAction.$$$reportNull$$$0(12);
        }
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(13);
        }
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            GroovyAddImportAction.$$$reportNull$$$0(14);
        }
        if (!this.ref.isValid()) {
            return false;
        }
        PsiFile containingFile = this.ref.getContainingFile();
        if (containingFile instanceof GroovyFile) {
            List alreadyImportedClasses = ContainerUtil.map((Object[])((GroovyFile)containingFile).getImportStatements(), GrImportStatement::resolveTargetClass);
            for (PsiClass classToImport : this.getClassesToImport()) {
                if (!alreadyImportedClasses.contains(classToImport)) continue;
                return false;
            }
        }
        return super.showHint(editor);
    }

    protected void bindReference(@NotNull PsiReference reference, @NotNull PsiClass targetClass) {
        PsiElement referringElement;
        if (reference == null) {
            GroovyAddImportAction.$$$reportNull$$$0(15);
        }
        if (targetClass == null) {
            GroovyAddImportAction.$$$reportNull$$$0(16);
        }
        if ((referringElement = reference.getElement()).getParent() instanceof GrMethodCall && referringElement instanceof GrReferenceExpression && PsiUtil.isNewified(referringElement)) {
            GroovyAddImportAction.handleNewifiedClass(referringElement, targetClass);
        } else {
            super.bindReference(reference, targetClass);
        }
    }

    private static void handleNewifiedClass(@NotNull PsiElement referringElement, @NotNull PsiClass targetClass) {
        PsiFile file;
        if (referringElement == null) {
            GroovyAddImportAction.$$$reportNull$$$0(17);
        }
        if (targetClass == null) {
            GroovyAddImportAction.$$$reportNull$$$0(18);
        }
        if ((file = referringElement.getContainingFile()) instanceof GroovyFile) {
            ((GroovyFile)file).importClass(targetClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GroovyAddImportAction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GroovyAddImportAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceNameElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isQualified";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterByContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredMemberName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "bindReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleNewifiedClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

