/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.secondUnsafeCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.inspections.SecondUnsafeCallQuickFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class SecondUnsafeCallInspection
extends GroovySuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SecondUnsafeCallInspection.$$$reportNull$$$0(0);
        }
        return new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression refExpression) {
                if (refExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                SecondUnsafeCallInspection.checkForSecondUnsafeCall(refExpression, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpression", "org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection$1", "visitReferenceExpression"));
            }
        });
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder) {
        SecondUnsafeCallInspection.checkForSecondUnsafeCall(expression, holder, null);
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder, @Nullable PsiElement highlightElement) {
        GrReferenceExpression referenceExpression;
        if (highlightElement == null) {
            highlightElement = expression;
        }
        if (GroovyTokenTypes.mDOT.equals((referenceExpression = (GrReferenceExpression)expression).getDotTokenType())) {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier instanceof GrMethodCallExpression) {
                GrExpression expression1 = ((GrMethodCallExpression)qualifier).getInvokedExpression();
                if (!(expression1 instanceof GrReferenceExpression)) {
                    return;
                }
                if (GroovyTokenTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)expression1).getDotTokenType())) {
                    holder.registerProblem(highlightElement, GroovyBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
                }
            } else if (qualifier instanceof GrReferenceExpression && GroovyTokenTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)qualifier).getDotTokenType())) {
                holder.registerProblem(highlightElement, GroovyBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection", "buildVisitor"));
    }
}

