/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsManagerConfigurable;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGeneralConfigurationConfigurable
implements SearchableConfigurable {
    private VcsGeneralConfigurationPanel myPanel;
    private final Project myProject;
    private final VcsManagerConfigurable myMainConfigurable;

    public VcsGeneralConfigurationConfigurable(Project project, VcsManagerConfigurable configurable) {
        this.myProject = project;
        this.myMainConfigurable = configurable;
    }

    @Nullable
    public JComponent createComponent() {
        this.myPanel = new VcsGeneralConfigurationPanel(this.myProject);
        if (this.getMappings() != null) {
            this.myPanel.updateAvailableOptions(this.getMappings().getActiveVcses());
            this.addListenerToGeneralPanel();
        } else {
            this.myPanel.updateAvailableOptions(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()));
        }
        this.addListenerToGeneralPanel();
        return this.myPanel.getPanel();
    }

    private VcsDirectoryConfigurationPanel getMappings() {
        return this.myMainConfigurable.getMappings();
    }

    private void addListenerToGeneralPanel() {
        VcsDirectoryConfigurationPanel mappings = this.getMappings();
        if (mappings != null) {
            mappings.addVcsListener(new ModuleVcsListener(){

                @Override
                public void activeVcsSetChanged(Collection<? extends AbstractVcs> activeVcses) {
                    VcsGeneralConfigurationConfigurable.this.myPanel.updateAvailableOptions(activeVcses);
                }
            });
        }
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
        this.myPanel = null;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"configurable.VcsGeneralConfigurationConfigurable.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "project.propVCSSupport.Confirmation";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            VcsGeneralConfigurationConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsGeneralConfigurationConfigurable", "getId"));
    }
}

