/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    @NonNls
    public static final String TAB_NAME = "Log";
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer;
    @Nullable
    private Consumer<? super MainVcsLogUi> myOnCreatedListener;
    @Nullable
    private MainVcsLogUi myUi;
    @Nullable
    private Content myContent;

    public VcsLogContentProvider(@NotNull Project project, @NotNull VcsProjectLog projectLog) {
        if (project == null) {
            VcsLogContentProvider.$$$reportNull$$$0(0);
        }
        if (projectLog == null) {
            VcsLogContentProvider.$$$reportNull$$$0(1);
        }
        this.myContainer = new JBPanel((LayoutManager)new BorderLayout());
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)projectLog);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager logManager) {
                if (logManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogContentProvider.this.addMainUi(logManager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager logManager) {
                if (logManager == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogContentProvider.this.disposeMainUi();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "logManager";
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logDisposed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        VcsLogManager manager = this.myProjectLog.getLogManager();
        if (manager != null) {
            this.addMainUi(manager);
        }
    }

    @Nullable
    public MainVcsLogUi getUi() {
        return this.myUi;
    }

    @Override
    public void initTabContent(@NotNull Content content2) {
        if (content2 == null) {
            VcsLogContentProvider.$$$reportNull$$$0(2);
        }
        this.myContent = content2;
        this.myContent.setTabName(TAB_NAME);
        this.updateDisplayName();
        this.myProjectLog.createLogInBackground(true);
        content2.setComponent((JComponent)this.myContainer);
        content2.setDisposer(() -> {
            this.disposeContent();
            this.myContent = null;
        });
    }

    @RequiresEdt
    private void addMainUi(@NotNull VcsLogManager logManager) {
        if (logManager == null) {
            VcsLogContentProvider.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myUi = logManager.createLogUi("MAIN", VcsLogManager.LogWindowKind.TOOL_WINDOW, false);
            VcsLogPanel panel2 = new VcsLogPanel(logManager, this.myUi);
            this.myContainer.add((Component)((Object)panel2), "Center");
            DataManager.registerDataProvider((JComponent)this.myContainer, (DataProvider)panel2);
            this.updateDisplayName();
            this.myUi.getFilterUi().addFilterListener(this::updateDisplayName);
            if (this.myOnCreatedListener != null) {
                this.myOnCreatedListener.consume((Object)this.myUi);
            }
            this.myOnCreatedListener = null;
        }
    }

    private void updateDisplayName() {
        if (this.myContent != null && this.myUi != null) {
            this.myContent.setDisplayName(VcsLogTabsManager.generateDisplayName(this.myUi));
        }
    }

    @RequiresEdt
    private void disposeMainUi() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myContainer.removeAll();
        DataManager.removeDataProvider((JComponent)this.myContainer);
        this.myOnCreatedListener = null;
        if (this.myUi != null) {
            MainVcsLogUi ui2 = this.myUi;
            this.myUi = null;
            Disposer.dispose((Disposable)ui2);
        }
    }

    @RequiresEdt
    public void executeOnMainUiCreated(@NotNull Consumer<? super MainVcsLogUi> consumer) {
        if (consumer == null) {
            VcsLogContentProvider.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myOnCreatedListener = consumer;
        } else {
            consumer.consume((Object)this.myUi);
        }
    }

    @Override
    public void disposeContent() {
        this.disposeMainUi();
    }

    @Nullable
    public static VcsLogContentProvider getInstance(@NotNull Project project) {
        if (project == null) {
            VcsLogContentProvider.$$$reportNull$$$0(5);
        }
        for (ChangesViewContentEP ep : ChangesViewContentEP.EP_NAME.getExtensions((AreaInstance)project)) {
            if (!ep.getClassName().equals(VcsLogContentProvider.class.getName())) continue;
            return (VcsLogContentProvider)ep.getCachedInstance();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initTabContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addMainUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOnMainUiCreated";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        public String get() {
            return VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]);
        }
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(@NotNull Project project) {
            if (project == null) {
                VcsLogVisibilityPredicate.$$$reportNull$$$0(0);
            }
            Boolean bl = !VcsProjectLog.getLogProviders(project).isEmpty();
            if (bl == null) {
                VcsLogVisibilityPredicate.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

