/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DateFilterPopupComponent
extends FilterPopupComponent<VcsLogDateFilter, FilterModel<VcsLogDateFilter>> {
    DateFilterPopupComponent(FilterModel<VcsLogDateFilter> filterModel) {
        super(VcsLogBundle.messagePointer((String)"vcs.log.date.filter.label", (Object[])new Object[0]), filterModel);
    }

    @Override
    @NotNull
    @Nls
    protected String getText(@NotNull VcsLogDateFilter filter) {
        if (filter == null) {
            DateFilterPopupComponent.$$$reportNull$$$0(0);
        }
        Date after = filter.getAfter();
        Date before = filter.getBefore();
        if (after != null && before != null) {
            String string = DateFormatUtil.formatDate((Date)after) + "-" + DateFormatUtil.formatDate((Date)before);
            if (string == null) {
                DateFilterPopupComponent.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (after != null) {
            String string = VcsLogBundle.message((String)"vcs.log.date.filter.since", (Object[])new Object[]{DateFormatUtil.formatDate((Date)after)});
            if (string == null) {
                DateFilterPopupComponent.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (before != null) {
            String string = VcsLogBundle.message((String)"vcs.log.date.filter.until", (Object[])new Object[]{DateFormatUtil.formatDate((Date)before)});
            if (string == null) {
                DateFilterPopupComponent.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = (String)ALL.get();
        if (string == null) {
            DateFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogDateFilter filter) {
        if (filter == null) {
            DateFilterPopupComponent.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Override
    protected ActionGroup createActionGroup() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(6, -1);
        Date oneDayBefore = cal.getTime();
        cal.add(6, -6);
        Date oneWeekBefore = cal.getTime();
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectAction(), new DateAction(oneDayBefore, VcsLogBundle.messagePointer((String)"vcs.log.date.filter.action.last.day", (Object[])new Object[0])), new DateAction(oneWeekBefore, VcsLogBundle.messagePointer((String)"vcs.log.date.filter.action.last.week", (Object[])new Object[0]))});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/DateFilterPopupComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/DateFilterPopupComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getToolTip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SelectAction
    extends DumbAwareAction {
        SelectAction() {
            super(VcsLogBundle.messagePointer((String)"vcs.log.filter.action.select", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectAction.$$$reportNull$$$0(0);
            }
            DateFilterComponent dateComponent = new DateFilterComponent(false, DateFormatUtil.getDateFormat().getDelegate());
            VcsLogDateFilter currentFilter = (VcsLogDateFilter)DateFilterPopupComponent.this.myFilterModel.getFilter();
            if (currentFilter != null) {
                if (currentFilter.getBefore() != null) {
                    dateComponent.setBefore(currentFilter.getBefore().getTime());
                }
                if (currentFilter.getAfter() != null) {
                    dateComponent.setAfter(currentFilter.getAfter().getTime());
                }
            }
            DialogBuilder db = new DialogBuilder((Component)DateFilterPopupComponent.this);
            db.addOkAction();
            db.setCenterPanel((JComponent)dateComponent.getPanel());
            db.setPreferredFocusComponent((JComponent)dateComponent.getPanel());
            db.setTitle(VcsLogBundle.message((String)"vcs.log.date.filter.select.period.dialog.title", (Object[])new Object[0]));
            if (0 == db.show()) {
                DateFilterPopupComponent.this.myFilterModel.setFilter(VcsLogFilterObject.fromDates(dateComponent.getAfter(), dateComponent.getBefore()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/DateFilterPopupComponent$SelectAction", "actionPerformed"));
        }
    }

    private class DateAction
    extends DumbAwareAction {
        @NotNull
        private final Date mySince;

        protected DateAction(@NotNull Date since, Supplier<String> text2) {
            if (since == null) {
                DateAction.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                DateAction.$$$reportNull$$$0(1);
            }
            super(text2);
            this.mySince = since;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DateAction.$$$reportNull$$$0(2);
            }
            DateFilterPopupComponent.this.myFilterModel.setFilter(VcsLogFilterObject.fromDates(this.mySince, null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "since";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/DateFilterPopupComponent$DateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

