/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.ArtifactRepositoryContainer;
import org.gradle.api.artifacts.UnknownRepositoryException;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultArtifactRepositoryContainer
extends DefaultNamedDomainObjectList<ArtifactRepository>
implements ArtifactRepositoryContainer {
    private final Action<ArtifactRepository> addLastAction = x$0 -> DefaultArtifactRepositoryContainer.access$101(this, x$0);

    public DefaultArtifactRepositoryContainer(Instantiator instantiator, CollectionCallbackActionDecorator callbackActionDecorator) {
        super(ArtifactRepository.class, instantiator, new RepositoryNamer(), callbackActionDecorator);
        this.whenObjectAdded((? super T artifactRepository) -> {
            if (artifactRepository instanceof ArtifactRepositoryInternal) {
                ArtifactRepositoryInternal repository = (ArtifactRepositoryInternal)artifactRepository;
                repository.onAddToContainer(this);
            }
        });
    }

    @Override
    public String getTypeDisplayName() {
        return "repository";
    }

    @Override
    public DefaultArtifactRepositoryContainer configure(Closure closure) {
        return ConfigureUtil.configureSelf(closure, this);
    }

    @Override
    public void addFirst(ArtifactRepository repository) {
        this.add(0, repository);
    }

    @Override
    public void addLast(ArtifactRepository repository) {
        this.add(repository);
    }

    @Override
    protected UnknownDomainObjectException createNotFoundException(String name) {
        return new UnknownRepositoryException(String.format("Repository with name '%s' not found.", name));
    }

    public <T extends ArtifactRepository> T addRepository(T repository, String defaultName) {
        return this.addRepository(repository, defaultName, Actions.doNothing());
    }

    public <T extends ArtifactRepository> T addRepository(T repository, String defaultName, Action<? super T> configureAction) {
        configureAction.execute(repository);
        return (T)this.addWithUniqueName(repository, defaultName, this.addLastAction);
    }

    private <T extends ArtifactRepository> T addWithUniqueName(T repository, String defaultName, Action<? super T> insertion) {
        String repositoryName = repository.getName();
        if (!GUtil.isTrue(repositoryName)) {
            repository.setName(this.uniquifyName(defaultName));
        } else {
            repository.setName(this.uniquifyName(repositoryName));
        }
        this.assertCanAdd(repository.getName());
        insertion.execute(repository);
        return repository;
    }

    private String uniquifyName(String proposedName) {
        if (this.findByName(proposedName) == null) {
            return proposedName;
        }
        int index = 2;
        String candidate;
        while (this.findByName(candidate = proposedName + index) != null) {
            ++index;
        }
        return candidate;
    }

    private static class RepositoryNamer
    implements Namer<ArtifactRepository> {
        private RepositoryNamer() {
        }

        @Override
        public String determineName(ArtifactRepository r) {
            return r.getName();
        }
    }
}

