/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.properties.LifecycleAwareValue;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class CachingTaskInputFileCollection
extends DefaultConfigurableFileCollection
implements LifecycleAwareValue {
    private boolean canCache;
    private FileCollectionInternal cachedValue;

    public CachingTaskInputFileCollection(PathToFileResolver fileResolver, Factory<PatternSet> patternSetFactory, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost) {
        super(null, fileResolver, taskDependencyFactory, patternSetFactory, propertyHost);
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        if (this.canCache) {
            if (this.cachedValue == null) {
                ImmutableSet.Builder files2 = ImmutableSet.builder();
                super.visitChildren(arg_0 -> ((ImmutableSet.Builder)files2).addAll(arg_0));
                this.cachedValue = new FileCollectionAdapter(new ListBackedFileSet((ImmutableSet<File>)files2.build()), this.patternSetFactory);
            }
            visitor.accept(this.cachedValue);
        } else {
            super.visitChildren(visitor);
        }
    }

    @Override
    public void prepareValue() {
        this.canCache = true;
    }

    @Override
    public void cleanupValue() {
        this.canCache = false;
        this.cachedValue = null;
    }
}

