/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources;

import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;

public abstract class EnvironmentVariableValueSource
implements ValueSource<String, Parameters>,
Describable {
    @Override
    @Nullable
    public String obtain() {
        String variableName = this.variableNameOrNull();
        if (variableName == null) {
            return null;
        }
        return System.getenv(variableName);
    }

    @Override
    public String getDisplayName() {
        return String.format("environment variable '%s'", this.variableNameOrNull());
    }

    private String variableNameOrNull() {
        return (String)((Parameters)this.getParameters()).getVariableName().getOrNull();
    }

    public static interface Parameters
    extends ValueSourceParameters {
        public Property<String> getVariableName();
    }
}

