/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AbstractRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.base.MoreObjects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.work.FileChange;

public class JavaRecompilationSpecProvider
extends AbstractRecompilationSpecProvider {
    private final boolean incremental;
    private final Iterable<FileChange> sourceChanges;
    private final SourceFileClassNameConverter sourceFileClassNameConverter;

    public JavaRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sourceTree, boolean incremental, Iterable<FileChange> sourceFileChanges, SourceFileClassNameConverter sourceFileClassNameConverter) {
        super(deleter, fileOperations, sourceTree);
        this.incremental = incremental;
        this.sourceChanges = sourceFileChanges;
        this.sourceFileClassNameConverter = sourceFileClassNameConverter;
    }

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec();
        if (this.sourceFileClassNameConverter.isEmpty()) {
            String fullRebuildCause = previous.getAnnotationProcessorFullRebuildCause();
            if (fullRebuildCause == null) {
                fullRebuildCause = "unable to get source-classes mapping relationship from last compilation";
            }
            spec.setFullRebuildCause(fullRebuildCause, null);
            return spec;
        }
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(current, previous, spec);
        spec.getClassesToProcess().addAll(previous.getTypesToReprocess());
        return spec;
    }

    @Override
    public boolean initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles((Iterable<File>)ImmutableSet.of());
            spec.setClasses(Collections.emptySet());
            return false;
        }
        PatternSet classesToDelete = this.fileOperations.patternSet();
        PatternSet sourceToCompile = this.fileOperations.patternSet();
        this.prepareFilePatterns(recompilationSpec.getRelativeSourcePathsToCompile(), classesToDelete, sourceToCompile);
        this.prepareJavaPatterns(recompilationSpec.getClassesToCompile(), classesToDelete, sourceToCompile);
        spec.setSourceFiles(this.narrowDownSourcesToCompile(this.sourceTree, sourceToCompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        boolean cleanedAnyOutput = this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
        cleanedAnyOutput |= this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory());
        cleanedAnyOutput |= this.deleteStaleFilesIn(classesToDelete, spec.getCompileOptions().getHeaderOutputDirectory());
        Map<GeneratedResource.Location, PatternSet> resourcesToDelete = JavaRecompilationSpecProvider.prepareResourcePatterns(recompilationSpec.getResourcesToGenerate(), this.fileOperations);
        cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.CLASS_OUTPUT), spec.getDestinationDir());
        cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.SOURCE_OUTPUT), (File)MoreObjects.firstNonNull((Object)spec.getCompileOptions().getAnnotationProcessorGeneratedSourcesDirectory(), (Object)spec.getDestinationDir()));
        return cleanedAnyOutput |= this.deleteStaleFilesIn(resourcesToDelete.get((Object)GeneratedResource.Location.NATIVE_HEADER_OUTPUT), spec.getCompileOptions().getHeaderOutputDirectory());
    }

    private Iterable<File> narrowDownSourcesToCompile(FileTree sourceTree, PatternSet sourceToCompile) {
        return sourceTree.matching(sourceToCompile);
    }

    private static Map<GeneratedResource.Location, PatternSet> prepareResourcePatterns(Collection<GeneratedResource> staleResources, FileOperations fileOperations) {
        EnumMap<GeneratedResource.Location, PatternSet> resourcesByLocation = new EnumMap<GeneratedResource.Location, PatternSet>(GeneratedResource.Location.class);
        for (GeneratedResource.Location location : GeneratedResource.Location.values()) {
            resourcesByLocation.put(location, fileOperations.patternSet());
        }
        for (GeneratedResource resource : staleResources) {
            ((PatternSet)resourcesByLocation.get((Object)resource.getLocation())).include(resource.getPath());
        }
        return resourcesByLocation;
    }

    private void processOtherChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        if (spec.isFullRebuildNeeded()) {
            return;
        }
        boolean emptyAnnotationProcessorPath = current.getAnnotationProcessorPath().isEmpty();
        SourceFileChangeProcessor sourceFileChangeProcessor = new SourceFileChangeProcessor(previous);
        for (FileChange fileChange : this.sourceChanges) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            if (fileChange.getFileType() != FileType.FILE) continue;
            File changedFile = fileChange.getFile();
            if (FileUtils.hasExtension(changedFile, ".java")) {
                String relativeFilePath = fileChange.getNormalizedPath();
                Collection<String> changedClasses = this.sourceFileClassNameConverter.getClassNames(relativeFilePath);
                spec.getRelativeSourcePathsToCompile().add(relativeFilePath);
                sourceFileChangeProcessor.processChange(changedFile, changedClasses, spec);
                continue;
            }
            if (emptyAnnotationProcessorPath) continue;
            spec.setFullRebuildCause(this.rebuildClauseForChangedNonSourceFile("resource", fileChange), null);
            return;
        }
        for (String className : spec.getClassesToCompile()) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            Optional<String> relativeSourceFile = this.sourceFileClassNameConverter.getRelativeSourcePath(className);
            relativeSourceFile.ifPresent(s -> spec.getRelativeSourcePathsToCompile().add((String)s));
        }
    }

    private void prepareFilePatterns(Set<String> relativeSourcePathsToCompile, PatternSet classesToDelete, PatternSet filesToRecompilePatterns) {
        for (String relativeSourcePath : relativeSourcePathsToCompile) {
            filesToRecompilePatterns.include(relativeSourcePath);
            this.sourceFileClassNameConverter.getClassNames(relativeSourcePath).stream().map(staleClass -> staleClass.replaceAll("\\.", "/").concat(".class")).forEach(xva$0 -> classesToDelete.include((String)xva$0));
        }
    }

    private void prepareJavaPatterns(Collection<String> staleClasses, PatternSet filesToDelete, PatternSet sourceToCompile) {
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            String headerPath = staleClass.replaceAll("\\.", "_");
            filesToDelete.include(path.concat(".class"));
            filesToDelete.include(path.concat(".java"));
            filesToDelete.include(headerPath.concat(".h"));
            filesToDelete.include(path.concat("$*.class"));
            filesToDelete.include(path.concat("$*.java"));
            filesToDelete.include(headerPath.concat("_*.h"));
            sourceToCompile.include(path.concat(".java"));
            sourceToCompile.include(path.concat("$*.java"));
        }
    }
}

