/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.changes.InputChangesInternal;

public class ExecuteStep<C extends InputChangesContext>
implements Step<C, Result> {
    @Override
    public Result execute(C context) {
        UnitOfWork work = context.getWork();
        try {
            ExecutionOutcome outcome = context.getInputChanges().map(inputChanges -> ExecuteStep.determineOutcome(work.execute((InputChangesInternal)inputChanges, (InputChangesContext)context), inputChanges.isIncremental())).orElseGet(() -> ExecuteStep.determineOutcome(work.execute(null, (InputChangesContext)context), false));
            return () -> Try.successful(outcome);
        }
        catch (Throwable t) {
            return () -> Try.failure(t);
        }
    }

    private static ExecutionOutcome determineOutcome(UnitOfWork.WorkResult result, boolean incremental) {
        switch (result) {
            case DID_NO_WORK: {
                return ExecutionOutcome.UP_TO_DATE;
            }
            case DID_WORK: {
                return incremental ? ExecutionOutcome.EXECUTED_INCREMENTALLY : ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
            }
        }
        throw new IllegalArgumentException("Unknown result: " + (Object)((Object)result));
    }
}

