/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.FileInfo;
import net.rubygrapefruit.platform.file.Files;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;

public class NativePlatformBackedFileMetadataAccessor
implements FileMetadataAccessor {
    private final Files files;

    public NativePlatformBackedFileMetadataAccessor(Files files2) {
        this.files = files2;
    }

    @Override
    public FileMetadata stat(File f) {
        FileInfo stat;
        try {
            stat = this.files.stat(f, false);
        }
        catch (NativeException e) {
            return DefaultFileMetadata.missing(FileMetadata.AccessType.DIRECT);
        }
        FileMetadata.AccessType accessType = FileMetadata.AccessType.viaSymlink(stat.getType() == FileInfo.Type.Symlink);
        if (accessType == FileMetadata.AccessType.VIA_SYMLINK) {
            try {
                stat = this.files.stat(f, true);
            }
            catch (NativeException e) {
                return DefaultFileMetadata.missing(FileMetadata.AccessType.VIA_SYMLINK);
            }
        }
        switch (stat.getType()) {
            case File: {
                return DefaultFileMetadata.file(stat.getLastModifiedTime(), stat.getSize(), accessType);
            }
            case Directory: {
                return DefaultFileMetadata.directory(accessType);
            }
            case Missing: 
            case Other: {
                return DefaultFileMetadata.missing(accessType);
            }
        }
        throw new IllegalArgumentException("Unrecognised file type: " + (Object)((Object)stat.getType()));
    }
}

