/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.plugins.signing.Signature;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.util.ConfigureUtil;

public abstract class SignOperation
implements SignatureSpec {
    private SignatureType signatureType;
    private Signatory signatory;
    private boolean required;
    private final List<Signature> signatures = new ArrayList<Signature>();

    public String getDisplayName() {
        return "SignOperation";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Override
    public void setSignatory(Signatory signatory) {
        this.signatory = signatory;
    }

    @Override
    public Signatory getSignatory() {
        return this.signatory;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public SignOperation sign(PublishArtifact ... artifacts) {
        for (PublishArtifact artifact : artifacts) {
            this.signatures.add(new Signature(artifact, (SignatureSpec)this, new Object[0]));
        }
        return this;
    }

    public SignOperation sign(File ... files2) {
        for (File file : files2) {
            this.signatures.add(new Signature(file, (SignatureSpec)this, new Object[0]));
        }
        return this;
    }

    public SignOperation sign(String classifier, File ... files2) {
        for (File file : files2) {
            this.signatures.add(new Signature(file, classifier, (SignatureSpec)this, new Object[0]));
        }
        return this;
    }

    public SignOperation signatureType(SignatureType type) {
        this.signatureType = type;
        return this;
    }

    public SignOperation signatory(Signatory signatory) {
        this.signatory = signatory;
        return this;
    }

    public SignOperation configure(Closure closure) {
        ConfigureUtil.configureSelf(closure, this);
        return this;
    }

    public SignOperation execute() {
        for (Signature signature : this.signatures) {
            signature.generate();
        }
        return this;
    }

    public List<Signature> getSignatures() {
        return new ArrayList<Signature>(this.signatures);
    }

    public Signature getSingleSignature() {
        int size = this.signatures.size();
        switch (size) {
            case 1: {
                return this.signatures.get(0);
            }
            case 0: {
                throw new IllegalStateException("Expected operation to contain exactly one signature, however, it contains no signatures.");
            }
        }
        throw new IllegalStateException("Expected operation to contain exactly one signature, however, it contains " + String.valueOf(size) + " signatures.");
    }

    public FileCollection getFilesToSign() {
        return this.newSignatureFileCollection((Function<Signature, File>)((Function)input -> input.getToSign()));
    }

    public FileCollection getSignatureFiles() {
        return this.newSignatureFileCollection((Function<Signature, File>)((Function)input -> input.getFile()));
    }

    private FileCollection newSignatureFileCollection(Function<Signature, File> getFile) {
        return this.toFileCollection(this.collectSignatureFiles(getFile));
    }

    protected abstract FileCollection toFileCollection(List<File> var1);

    private List<File> collectSignatureFiles(Function<Signature, File> getFile) {
        ArrayList<File> files2 = new ArrayList<File>(this.signatures.size());
        for (Signature signature : this.signatures) {
            File file = (File)getFile.apply((Object)signature);
            if (file == null) continue;
            files2.add(file);
        }
        return files2;
    }
}

