/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.XmlRpcDelegatingHttpRequestHandler;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/io/SubServer;", "Lorg/jetbrains/ide/CustomPortServerManager$CustomPortService;", "Lcom/intellij/openapi/Disposable;", "user", "Lorg/jetbrains/ide/CustomPortServerManager;", "server", "Lorg/jetbrains/io/BuiltInServer;", "(Lorg/jetbrains/ide/CustomPortServerManager;Lorg/jetbrains/io/BuiltInServer;)V", "channelRegistrar", "Lorg/jetbrains/io/ChannelRegistrar;", "isBound", "", "()Z", "bind", "port", "", "dispose", "", "rebind", "stop", "intellij.platform.builtInServer.impl"})
public final class SubServer
implements CustomPortServerManager.CustomPortService,
Disposable {
    private ChannelRegistrar channelRegistrar;
    private final CustomPortServerManager user;
    private final BuiltInServer server;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBound() {
        if (this.channelRegistrar == null) return false;
        ChannelRegistrar channelRegistrar = this.channelRegistrar;
        Intrinsics.checkNotNull((Object)channelRegistrar);
        if (channelRegistrar.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean bind(int port) {
        if (port == this.server.getPort() || port == -1) {
            return true;
        }
        if (this.channelRegistrar == null) {
            Disposer.register((Disposable)((Disposable)this.server), (Disposable)this);
            this.channelRegistrar = new ChannelRegistrar();
        }
        ServerBootstrap bootstrap = NettyKt.serverBootstrap((EventLoopGroup)this.server.getEventLoopGroup());
        Map xmlRpcHandlers = this.user.createXmlRpcHandlers();
        if (xmlRpcHandlers == null) {
            ChannelRegistrar channelRegistrar = this.channelRegistrar;
            Intrinsics.checkNotNull((Object)channelRegistrar);
            BuiltInServer.Companion.configureChildHandler(bootstrap, channelRegistrar, null);
        } else {
            XmlRpcDelegatingHttpRequestHandler handler2 = new XmlRpcDelegatingHttpRequestHandler(xmlRpcHandlers);
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(this, handler2){
                final /* synthetic */ SubServer this$0;
                final /* synthetic */ XmlRpcDelegatingHttpRequestHandler $handler;

                protected void initChannel(@NotNull Channel channel) {
                    Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                    ChannelPipeline channelPipeline = channel.pipeline();
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
                    ChannelRegistrar channelRegistrar = SubServer.access$getChannelRegistrar$p(this.this$0);
                    Intrinsics.checkNotNull((Object)channelRegistrar);
                    channelHandlerArray[0] = (ChannelHandler)channelRegistrar;
                    channelPipeline.addLast(channelHandlerArray);
                    NettyUtil.addHttpServerCodec((ChannelPipeline)channel.pipeline());
                    channel.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)this.$handler});
                }
                {
                    this.this$0 = this$0;
                    this.$handler = $captured_local_variable$1;
                }
            });
        }
        try {
            bootstrap.localAddress((SocketAddress)(this.user.isAvailableExternally() ? new InetSocketAddress(port) : NetKt.loopbackSocketAddress((int)port)));
            ChannelRegistrar channelRegistrar = this.channelRegistrar;
            Intrinsics.checkNotNull((Object)channelRegistrar);
            channelRegistrar.setServerChannel(bootstrap.bind().syncUninterruptibly().channel(), false);
            return true;
        }
        catch (Exception e) {
            try {
                NettyUtil.log((Throwable)e, (Logger)Logger.getInstance(BuiltInServer.class));
            }
            finally {
                this.user.cannotBind(e, port);
            }
            return false;
        }
    }

    private final void stop() {
        block0: {
            ChannelRegistrar channelRegistrar = this.channelRegistrar;
            if (channelRegistrar == null) break block0;
            channelRegistrar.close();
        }
    }

    public boolean rebind() {
        this.stop();
        return this.bind(this.user.getPort());
    }

    public void dispose() {
        this.stop();
        this.user.setManager(null);
    }

    public SubServer(@NotNull CustomPortServerManager user, @NotNull BuiltInServer server) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.user = user;
        this.server = server;
        this.user.setManager((CustomPortServerManager.CustomPortService)this);
    }

    public static final /* synthetic */ ChannelRegistrar access$getChannelRegistrar$p(SubServer $this) {
        return $this.channelRegistrar;
    }

    public static final /* synthetic */ void access$setChannelRegistrar$p(SubServer $this, ChannelRegistrar channelRegistrar) {
        $this.channelRegistrar = channelRegistrar;
    }
}

