/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.ui.GlassHighlightComponent;
import training.ui.LearningUiHighlightingManager;
import training.ui.RepaintByTimer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ltraining/ui/GeneralPartRepaint;", "T", "Ljava/awt/Component;", "Ltraining/ui/RepaintByTimer;", "whole", "glassPane", "Ljavax/swing/JComponent;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "rectangle", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ljavax/swing/JComponent;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Lkotlin/jvm/functions/Function0;)V", "cellBoundsInList", "listLocationOnScreen", "Ljava/awt/Point;", "getRectangle", "()Lkotlin/jvm/functions/Function0;", "reinitHighlightComponent", "", "shouldReinit", "", "intellij.featuresTrainer"})
public final class GeneralPartRepaint<T extends Component>
extends RepaintByTimer<T> {
    private Point listLocationOnScreen;
    private Rectangle cellBoundsInList;
    @NotNull
    private final Function0<Rectangle> rectangle;

    @Override
    protected boolean shouldReinit() {
        return this.getHighlightComponent() == null || Intrinsics.areEqual((Object)((Component)this.getOriginal()).getLocationOnScreen(), (Object)this.listLocationOnScreen) ^ true || Intrinsics.areEqual((Object)((Rectangle)this.getRectangle().invoke()), (Object)this.cellBoundsInList) ^ true;
    }

    @Override
    public void reinitHighlightComponent() {
        Rectangle rectangle2 = (Rectangle)this.getRectangle().invoke();
        if (rectangle2 == null) {
            return;
        }
        Rectangle cellBounds = rectangle2;
        GlassHighlightComponent newHighlightComponent = new GlassHighlightComponent(this.getStartDate(), this.getOptions());
        Point pt = SwingUtilities.convertPoint(this.getOriginal(), cellBounds.getLocation(), this.getGlassPane());
        Rectangle bounds = new Rectangle(pt.x, pt.y, cellBounds.width, cellBounds.height);
        newHighlightComponent.setBounds(bounds);
        this.getGlassPane().add(newHighlightComponent);
        this.setHighlightComponent(newHighlightComponent);
        this.listLocationOnScreen = ((Component)this.getOriginal()).getLocationOnScreen();
        this.cellBoundsInList = cellBounds;
    }

    @Override
    @NotNull
    public Function0<Rectangle> getRectangle() {
        return this.rectangle;
    }

    public GeneralPartRepaint(@NotNull T whole2, @NotNull JComponent glassPane, @NotNull LearningUiHighlightingManager.HighlightingOptions options, @NotNull Function0<? extends Rectangle> rectangle2) {
        Intrinsics.checkNotNullParameter(whole2, (String)"whole");
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(rectangle2, (String)"rectangle");
        super(whole2, glassPane, options);
        this.rectangle = rectangle2;
    }
}

