/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.DeviceProcessTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.collect.Sets;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DeviceProcessPoller
extends PollRunner {
    @NotNull
    private final DeviceProcessTable myTable;
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myPollingService;
    @NotNull
    private final Map<Long, DeviceData> myDevices;

    public DeviceProcessPoller(@NotNull DeviceProcessTable table, @NotNull TransportServiceGrpc.TransportServiceBlockingStub pollingService) {
        if (table == null) {
            DeviceProcessPoller.$$$reportNull$$$0(0);
        }
        if (pollingService == null) {
            DeviceProcessPoller.$$$reportNull$$$0(1);
        }
        super(TimeUnit.SECONDS.toNanos(1L));
        this.myDevices = new HashMap<Long, DeviceData>();
        this.myTable = table;
        this.myPollingService = pollingService;
    }

    @Override
    public void stop() {
        super.stop();
        this.disconnect();
    }

    @Override
    public void poll() {
        try {
            Transport.GetDevicesRequest devicesRequest = Transport.GetDevicesRequest.newBuilder().build();
            Transport.GetDevicesResponse deviceResponse = this.myPollingService.getDevices(devicesRequest);
            for (Common.Device device : deviceResponse.getDeviceList()) {
                long deviceId = device.getDeviceId();
                this.myTable.insertOrUpdateDevice(device);
                DeviceData deviceData = this.myDevices.computeIfAbsent(deviceId, s -> new DeviceData(device));
                Transport.GetProcessesRequest processesRequest = Transport.GetProcessesRequest.newBuilder().setDeviceId(deviceId).build();
                Transport.GetProcessesResponse processesResponse = this.myPollingService.getProcesses(processesRequest);
                HashSet<Common.Process> liveProcesses = new HashSet<Common.Process>();
                for (Common.Process process : processesResponse.getProcessList()) {
                    assert (process.getDeviceId() == deviceId);
                    this.myTable.insertOrUpdateProcess(deviceId, process);
                    liveProcesses.add(process);
                    Transport.AgentStatusRequest agentStatusRequest = Transport.AgentStatusRequest.newBuilder().setPid(process.getPid()).setDeviceId(deviceId).build();
                    Common.AgentData cachedData = this.myTable.getAgentStatus(agentStatusRequest);
                    if (cachedData.getStatus() == Common.AgentData.Status.UNSPECIFIED) {
                        Common.AgentData agentData = this.myPollingService.getAgentStatus(agentStatusRequest);
                        this.myTable.updateAgentStatus(deviceId, process, agentData);
                    }
                    deviceData.processes.add(process);
                }
                Sets.SetView deadProcesses = Sets.difference(deviceData.processes, liveProcesses);
                this.killProcesses(deviceId, (Set<Common.Process>)deadProcesses);
            }
        }
        catch (StatusRuntimeException ex) {
            this.disconnect();
        }
    }

    private void disconnect() {
        for (Map.Entry<Long, DeviceData> entry : this.myDevices.entrySet()) {
            this.disconnectDevice(entry.getValue().device);
            this.killProcesses(entry.getKey(), entry.getValue().processes);
        }
        this.myDevices.clear();
    }

    private void disconnectDevice(Common.Device device) {
        Common.Device disconnectedDevice = device.toBuilder().setState(Common.Device.State.DISCONNECTED).build();
        this.myTable.insertOrUpdateDevice(disconnectedDevice);
    }

    private void killProcesses(long deviceId, Set<Common.Process> processes) {
        for (Common.Process process : processes) {
            Common.Process updatedProcess = process.toBuilder().setState(Common.Process.State.DEAD).build();
            this.myTable.insertOrUpdateProcess(deviceId, updatedProcess);
            Common.AgentData agentData = this.myTable.getAgentStatus(Transport.AgentStatusRequest.newBuilder().setDeviceId(deviceId).setPid(process.getPid()).build());
            if (agentData.getStatus() != Common.AgentData.Status.UNSPECIFIED) continue;
            this.myTable.updateAgentStatus(deviceId, process, agentData.toBuilder().setStatus(Common.AgentData.Status.UNATTACHABLE).build());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pollingService";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/poller/DeviceProcessPoller";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DeviceData {
        public final Common.Device device;
        public final Set<Common.Process> processes = new HashSet<Common.Process>();

        public DeviceData(Common.Device device) {
            this.device = device;
        }
    }
}

