/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.intellij.openapi.keymap.KeymapUtil;
import java.awt.event.ActionEvent;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfilerAction
implements ContextMenuItem {
    @NotNull
    private final Supplier<String> myText;
    @NotNull
    private final Runnable myActionRunnable;
    @NotNull
    private final BooleanSupplier myEnableBooleanSupplier;
    @NotNull
    private final KeyStroke[] myKeyStrokes;
    @Nullable
    private final Supplier<Icon> myIcon;

    private ProfilerAction(Builder builder) {
        this.myText = builder.myText;
        this.myActionRunnable = builder.myActionRunnable;
        this.myEnableBooleanSupplier = builder.myEnableBooleanSupplier;
        this.myKeyStrokes = builder.myKeyStrokes;
        this.myIcon = builder.myIcon;
        JComponent containerComponent = builder.myContainerComponent;
        if (containerComponent == null || this.myKeyStrokes.length == 0) {
            return;
        }
        InputMap inputMap = containerComponent.getInputMap(1);
        ActionMap actionMap = containerComponent.getActionMap();
        String label = this.getDefaultToolTipText();
        for (KeyStroke keyStroke : this.myKeyStrokes) {
            inputMap.put(keyStroke, label);
        }
        actionMap.put(label, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isEnabled()) {
                    ProfilerAction.this.run();
                }
            }
        });
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText.get();
        if (string == null) {
            ProfilerAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myIcon == null ? null : this.myIcon.get();
    }

    @Override
    public boolean isEnabled() {
        return this.myEnableBooleanSupplier.getAsBoolean();
    }

    @Override
    @NotNull
    public KeyStroke[] getKeyStrokes() {
        if (this.myKeyStrokes == null) {
            ProfilerAction.$$$reportNull$$$0(1);
        }
        return this.myKeyStrokes;
    }

    @Override
    public void run() {
        this.myActionRunnable.run();
    }

    public String getDefaultToolTipText() {
        String text = this.myText.get();
        if (this.myKeyStrokes.length != 0) {
            return text + " (" + KeymapUtil.getKeystrokeText((KeyStroke)this.myKeyStrokes[0]) + ")";
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/profilers/ProfilerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Builder {
        @NotNull
        private Runnable myActionRunnable;
        @NotNull
        private BooleanSupplier myEnableBooleanSupplier;
        @NotNull
        private Supplier<String> myText;
        @NotNull
        private KeyStroke[] myKeyStrokes;
        @Nullable
        private Supplier<Icon> myIcon;
        @Nullable
        private JComponent myContainerComponent;

        public Builder(@NotNull String text) {
            if (text == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this(() -> text);
        }

        public Builder(@NotNull Supplier<String> text) {
            if (text == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myActionRunnable = () -> {};
            this.myEnableBooleanSupplier = () -> true;
            this.myKeyStrokes = new KeyStroke[0];
        }

        public Builder setActionRunnable(@NotNull Runnable actionRunnable) {
            if (actionRunnable == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myActionRunnable = actionRunnable;
            return this;
        }

        public Builder setEnableBooleanSupplier(@NotNull BooleanSupplier enable) {
            if (enable == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myEnableBooleanSupplier = enable;
            return this;
        }

        public Builder setKeyStrokes(KeyStroke ... keyStrokes) {
            if (keyStrokes == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myKeyStrokes = keyStrokes;
            return this;
        }

        public Builder setIcon(@Nullable Icon icon) {
            return this.setIcon(() -> icon);
        }

        public Builder setIcon(@Nullable Supplier<Icon> icon) {
            this.myIcon = icon;
            return this;
        }

        public Builder setContainerComponent(@Nullable JComponent containerComponent) {
            this.myContainerComponent = containerComponent;
            return this;
        }

        public ProfilerAction build() {
            return new ProfilerAction(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionRunnable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyStrokes";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/profilers/ProfilerAction$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setActionRunnable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setEnableBooleanSupplier";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setKeyStrokes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

