/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceProducer;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.atrace.PerfettoProducer;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfTraceParser;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParser {
    @VisibleForTesting
    static final int MAX_SUPPORTED_TRACE_SIZE = 0x6400000;
    static final long IMPORTED_TRACE_ID = 42L;
    private final Map<Long, CompletableFuture<CpuCapture>> myCaptures;
    @NotNull
    private final IdeProfilerServices myServices;
    private final AspectModel<CpuProfilerAspect> myAspect;
    private boolean myIsParsing;
    private long myParsingStartTimeMs;
    private String myProcessNameHint;
    private int myProcessIdHint;
    private Map<Long, CpuCaptureMetadata> myCaptureMetadataMap;
    private static Set<String> myPreviouslyLoadedCaptures = new HashSet<String>();

    public CpuCaptureParser(@NotNull IdeProfilerServices services) {
        if (services == null) {
            CpuCaptureParser.$$$reportNull$$$0(0);
        }
        this.myAspect = new AspectModel();
        this.myCaptureMetadataMap = new HashMap<Long, CpuCaptureMetadata>();
        this.myServices = services;
        this.myCaptures = new HashMap<Long, CompletableFuture<CpuCapture>>();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuCaptureParser.class);
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @VisibleForTesting
    static void clearPreviouslyLoadedCaptures() {
        myPreviouslyLoadedCaptures.clear();
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCapture(long traceId) {
        return this.myCaptures.get(traceId);
    }

    /*
     * WARNING - void declaration
     */
    void trackCaptureMetadata(long traceId, @NotNull CpuCaptureMetadata cpuCaptureMetadata) {
        void metadata;
        if (cpuCaptureMetadata == null) {
            CpuCaptureParser.$$$reportNull$$$0(1);
        }
        this.myCaptureMetadataMap.put(traceId, (CpuCaptureMetadata)metadata);
    }

    public void abortParsing() {
        this.myCaptures.forEach((id, capture) -> {
            boolean isCaptureCancelled = capture.cancel(true);
            if (!isCaptureCancelled) {
                CpuCaptureParser.getLogger().warn(String.format("Parsing of capture %d was not properly cancelled.", id));
            }
        });
    }

    public boolean isParsing() {
        return this.myIsParsing;
    }

    public long getParsingElapsedTimeMs() {
        return System.currentTimeMillis() - this.myParsingStartTimeMs;
    }

    public void setProcessNameHint(@Nullable String processName, int processIdHint) {
        this.myProcessNameHint = processName;
        this.myProcessIdHint = processIdHint;
    }

    @Nullable
    private void updateParsingStateWhenDone(@Nullable CompletableFuture<CpuCapture> future) {
        if (future != null) {
            future.whenCompleteAsync((capture, exception) -> {
                this.myIsParsing = false;
                this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
            }, this.myServices.getMainExecutor());
        } else {
            this.myIsParsing = false;
            this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
        }
    }

    @VisibleForTesting
    public void updateParsingStateWhenStarting() {
        this.myParsingStartTimeMs = System.currentTimeMillis();
        this.myIsParsing = true;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
    }

    @Nullable
    @VisibleForTesting
    public CompletableFuture<CpuCapture> parse(@NotNull File traceFile) {
        if (traceFile == null) {
            CpuCaptureParser.$$$reportNull$$$0(2);
        }
        return this.parse(traceFile, true);
    }

    @Nullable
    public CompletableFuture<CpuCapture> parse(@NotNull File traceFile, boolean captureImportedTraceMetrics) {
        if (traceFile == null) {
            CpuCaptureParser.$$$reportNull$$$0(3);
        }
        if (!traceFile.exists() || traceFile.isDirectory()) {
            CpuCaptureParser.getLogger().info("Trace not parsed, as its path doesn't exist or points to a directory.");
            return null;
        }
        this.updateParsingStateWhenStarting();
        long fileLength = traceFile.length();
        if (fileLength > 0x6400000L) {
            Runnable yesCallback = () -> {
                CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", fileLength));
                this.myCaptures.put(42L, this.createCaptureFuture(traceFile));
            };
            Runnable noCallback = () -> {
                CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", fileLength));
                this.myCaptures.put(42L, null);
            };
            this.openParseLargeTracesDialog(yesCallback, noCallback);
        } else {
            this.myCaptures.put(42L, this.createCaptureFuture(traceFile));
        }
        if (!myPreviouslyLoadedCaptures.contains(traceFile.getAbsolutePath())) {
            if (captureImportedTraceMetrics) {
                CompletableFuture<CpuCapture> future = this.myCaptures.get(42L);
                if (future != null) {
                    future.whenCompleteAsync((capture, exception) -> {
                        if (capture != null) {
                            this.myServices.getFeatureTracker().trackImportTrace(capture.getType(), true);
                        }
                    }, this.myServices.getMainExecutor());
                }
            } else {
                this.trackCaptureTrace(42L, (int)traceFile.length());
            }
            myPreviouslyLoadedCaptures.add(traceFile.getAbsolutePath());
        }
        this.updateParsingStateWhenDone(this.myCaptures.get(42L));
        return this.myCaptures.get(42L);
    }

    private CompletableFuture<CpuCapture> createCaptureFuture(@NotNull File traceFile) {
        if (traceFile == null) {
            CpuCaptureParser.$$$reportNull$$$0(4);
        }
        CompletableFuture<CpuCapture> future = CompletableFuture.supplyAsync(() -> this.tryParsingFileWithDifferentParsers(traceFile), this.myServices.getPoolExecutor());
        return future;
    }

    private CpuCapture tryParsingFileWithDifferentParsers(File traceFile) {
        try {
            ArtTraceParser artTraceParser = new ArtTraceParser();
            return artTraceParser.parse(traceFile, 42L);
        }
        catch (Exception artTraceParser) {
            try {
                SimpleperfTraceParser simpleperfParser = new SimpleperfTraceParser();
                return simpleperfParser.parse(traceFile, 42L);
            }
            catch (Exception simpleperfParser) {
                try {
                    if (AtraceProducer.verifyFileHasAtraceHeader(traceFile) || this.myServices.getFeatureConfig().isPerfettoEnabled() && PerfettoProducer.verifyFileHasPerfettoTraceHeader(traceFile)) {
                        AtraceParser parser = new AtraceParser(traceFile);
                        CpuThreadSliceInfo[] processList = parser.getProcessList(this.myServices.getApplicationId());
                        CpuThreadSliceInfo selected = null;
                        if (StringUtil.isNotEmpty((String)this.myProcessNameHint)) {
                            selected = Arrays.stream(processList).filter(it -> this.myProcessNameHint.endsWith(it.getProcessName())).findFirst().orElse(null);
                        }
                        if (selected == null && this.myProcessIdHint > 0) {
                            selected = Arrays.stream(processList).filter(it -> it.getProcessId() == this.myProcessIdHint).findFirst().orElse(null);
                        }
                        if (selected == null) {
                            selected = this.myServices.openListBoxChooserDialog("Select a process", "Select the process you want to analyze.", processList, t -> t.getProcessName());
                        }
                        if (selected != null) {
                            parser.setSelectProcess(selected);
                            return parser.parse(traceFile, 42L);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CpuCaptureParser.getLogger().warn(String.format("Parsing %s has failed.", traceFile.getPath()));
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CompletableFuture<CpuCapture> parse(@NotNull Common.Session session, long traceId, @NotNull ByteString traceData, Cpu.CpuTraceType cpuTraceType) {
        if (session == null) {
            CpuCaptureParser.$$$reportNull$$$0(5);
        }
        if (traceData == null) {
            CpuCaptureParser.$$$reportNull$$$0(6);
        }
        this.updateParsingStateWhenStarting();
        if (!this.myCaptures.containsKey(traceId)) {
            void profilerType;
            if (traceData.size() <= 0x6400000) {
                this.myCaptures.put(traceId, this.createCaptureFuture(session, traceId, traceData, (Cpu.CpuTraceType)profilerType));
            } else {
                Runnable yesCallback = () -> this.lambda$parse$9(traceData, traceId, session, (Cpu.CpuTraceType)profilerType);
                Runnable noCallback = () -> {
                    CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", traceData.size()));
                    this.myCaptures.put(traceId, null);
                };
                this.openParseLargeTracesDialog(yesCallback, noCallback);
            }
        }
        CompletableFuture<CpuCapture> future = this.trackCaptureTrace(traceId, traceData.size());
        this.updateParsingStateWhenDone(future);
        return future;
    }

    @Nullable
    private CompletableFuture<CpuCapture> trackCaptureTrace(long traceId, int traceDataSize) {
        CpuCaptureMetadata metadata = this.myCaptureMetadataMap.computeIfAbsent(traceId, id -> new CpuCaptureMetadata(new ProfilingConfiguration()));
        CompletableFuture<CpuCapture> future = this.myCaptures.get(traceId);
        metadata.setTraceFileSizeBytes(traceDataSize);
        if (future != null) {
            future.whenCompleteAsync((capture, exception) -> {
                if (capture != null) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                    metadata.setParsingTimeMs(System.currentTimeMillis() - this.myParsingStartTimeMs);
                    metadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(capture.getDurationUs()));
                    metadata.setRecordDurationMs(CpuCaptureParser.calculateRecordDurationMs(capture));
                } else if (future.isCancelled()) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
                    this.myServices.showNotification(CpuProfilerNotifications.PARSING_ABORTED);
                } else if (exception != null) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                    CpuCaptureParser.getLogger().warn("Unable to parse capture: " + exception.getMessage(), exception);
                    this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                }
                if (this.myCaptureMetadataMap.containsKey(traceId)) {
                    this.myServices.getFeatureTracker().trackCaptureTrace(metadata);
                    this.myCaptureMetadataMap.remove(traceId);
                }
            }, this.myServices.getMainExecutor());
        } else {
            metadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.myServices.showNotification(CpuProfilerNotifications.PARSING_ABORTED);
            if (this.myCaptureMetadataMap.containsKey(traceId)) {
                this.myServices.getFeatureTracker().trackCaptureTrace(metadata);
                this.myCaptureMetadataMap.remove(traceId);
            }
        }
        return future;
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread2 : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread2.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<CpuCapture> createCaptureFuture(@NotNull Common.Session session, long traceId, ByteString traceBytes, Cpu.CpuTraceType cpuTraceType) {
        void profilerType;
        if (session == null) {
            CpuCaptureParser.$$$reportNull$$$0(7);
        }
        CpuCaptureMetadata metadata = this.myCaptureMetadataMap.containsKey(traceId) ? this.myCaptureMetadataMap.get(traceId) : new CpuCaptureMetadata(new ProfilingConfiguration());
        CompletionStage future = CompletableFuture.supplyAsync(() -> this.lambda$createCaptureFuture$13(traceBytes, metadata, session, traceId, (Cpu.CpuTraceType)profilerType), this.myServices.getPoolExecutor()).thenApplyAsync(capture -> {
            if (metadata.getStatus() == CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE) {
                this.myServices.showNotification(CpuProfilerNotifications.PREPROCESS_FAILURE);
                CpuCaptureParser.getLogger().warn("Unable to pre-process trace file.");
            }
            return capture;
        }, this.myServices.getMainExecutor());
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private CpuCapture traceBytesToCapture(@NotNull Common.Session session, long traceId, @NotNull ByteString traceData, Cpu.CpuTraceType cpuTraceType) {
        if (session == null) {
            CpuCaptureParser.$$$reportNull$$$0(8);
        }
        if (traceData == null) {
            CpuCaptureParser.$$$reportNull$$$0(9);
        }
        try {
            TraceParser parser;
            void profilerType;
            File trace = CpuCaptureStage.saveCapture(traceId, traceData);
            if (profilerType == Cpu.CpuTraceType.ART) {
                parser = new ArtTraceParser();
            } else if (profilerType == Cpu.CpuTraceType.SIMPLEPERF) {
                parser = new SimpleperfTraceParser();
            } else if (profilerType == Cpu.CpuTraceType.ATRACE) {
                parser = new AtraceParser(session.getPid());
            } else {
                throw new IllegalStateException("Trace file cannot be parsed. Profiler type (ART, simpleperf, or atrace) needs to be set.");
            }
            return parser.parse(trace, traceId);
        }
        catch (IOException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }

    private void openParseLargeTracesDialog(Runnable yesCallback, Runnable noCallback) {
        this.myServices.openYesNoDialog("The trace file generated is large, and Android Studio may become unresponsive while it parses the data. Do you want to continue?\n\nWarning: If you select \"No\", Android Studio discards the trace data and you will need to capture a new method trace.", "Trace File Too Large", yesCallback, noCallback);
    }

    private /* synthetic */ CpuCapture lambda$createCaptureFuture$13(ByteString traceBytes, CpuCaptureMetadata metadata, Common.Session session, long traceId, Cpu.CpuTraceType profilerType) {
        ByteString processedBytes = traceBytes;
        metadata.setTraceFileSizeBytes(processedBytes.size());
        boolean failedToPreProcess = processedBytes.equals((Object)TracePreProcessor.FAILURE);
        if (failedToPreProcess) {
            metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE);
            return null;
        }
        return this.traceBytesToCapture(session, traceId, processedBytes, profilerType);
    }

    private /* synthetic */ void lambda$parse$9(ByteString traceData, long traceId, Common.Session session, Cpu.CpuTraceType profilerType) {
        CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", traceData.size()));
        this.myCaptures.put(traceId, this.createCaptureFuture(session, traceId, traceData, profilerType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceFile";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceData";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "trackCaptureMetadata";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaptureFuture";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "traceBytesToCapture";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

