/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadStateDataSeries
implements DataSeries<CpuProfilerStage.ThreadState> {
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    private final long myStreamId;
    private final int myPid;
    private final int myThreadId;
    @Nullable
    private final CpuCapture mySelectedCapture;

    /*
     * WARNING - void declaration
     */
    public CpuThreadStateDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, long streamId, int pid, int threadId, @Nullable CpuCapture cpuCapture) {
        void selectedCapture;
        if (client == null) {
            CpuThreadStateDataSeries.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myStreamId = streamId;
        this.myPid = pid;
        this.myThreadId = threadId;
        this.mySelectedCapture = selectedCapture;
    }

    public List<SeriesData<CpuProfilerStage.ThreadState>> getDataForRange(Range rangeUs) {
        ArrayList<SeriesData<CpuProfilerStage.ThreadState>> series = new ArrayList<SeriesData<CpuProfilerStage.ThreadState>>();
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.CPU_THREAD).setGroupId((long)this.myThreadId).setFromTimestamp(minNs).setToTimestamp(maxNs).build());
        assert (response.getGroupsCount() <= 1);
        if (response.getGroupsCount() == 1) {
            ArrayList<Double> captureTimes = new ArrayList<Double>(2);
            if (this.mySelectedCapture != null && this.mySelectedCapture.getThreads().stream().anyMatch(t -> t.getId() == this.myThreadId)) {
                captureTimes.add(this.mySelectedCapture.getRange().getMin());
                captureTimes.add(this.mySelectedCapture.getRange().getMax());
            }
            int i = 0;
            int j = 0;
            boolean inCapture = false;
            Cpu.CpuThreadData.State state = Cpu.CpuThreadData.State.UNSPECIFIED;
            List events = response.getGroups(0).getEventsList();
            while (i < events.size()) {
                long time;
                long captureTime;
                Common.Event event = (Common.Event)events.get(i);
                long timestamp = TimeUnit.NANOSECONDS.toMicros(event.getTimestamp());
                long l = captureTime = j < captureTimes.size() ? ((Double)captureTimes.get(j)).longValue() : Long.MAX_VALUE;
                if (captureTime < timestamp) {
                    inCapture = !inCapture;
                    time = captureTime;
                    ++j;
                } else {
                    state = event.getCpuThread().getState();
                    time = timestamp;
                    ++i;
                }
                if (state == Cpu.CpuThreadData.State.UNSPECIFIED) continue;
                series.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(time, (Object)CpuThreadsModel.getState(state, inCapture)));
            }
            while (j < captureTimes.size()) {
                inCapture = !inCapture;
                series.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(((Double)captureTimes.get(j)).longValue(), (Object)CpuThreadsModel.getState(state, inCapture)));
                ++j;
            }
        }
        return series;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/profilers/cpu/CpuThreadStateDataSeries", "<init>"));
    }
}

