/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.trackgroup.SelectableTrackModel;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltip;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CpuThreadTrackModel
implements CpuAnalyzable<CpuThreadTrackModel> {
    private final StateChartModel<CpuProfilerStage.ThreadState> myThreadStateChartModel;
    private final CaptureDetails.CallChart myCallChartModel;
    private final CpuCapture myCapture;
    private final Range mySelectionRange;
    private final CpuThreadInfo myThreadInfo;
    @NotNull
    private final CpuThreadsTooltip myThreadStateTooltip;
    @NotNull
    private final Function<CaptureNode, CpuCaptureNodeTooltip> myTraceEventTooltipBuilder;
    @NotNull
    private final MultiSelectionModel<CpuAnalyzable> myMultiSelectionModel;

    public CpuThreadTrackModel(@NotNull Range range, @NotNull CpuCapture capture, @NotNull CpuThreadInfo threadInfo, @NotNull Timeline timeline, @NotNull MultiSelectionModel<CpuAnalyzable> multiSelectionModel) {
        if (range == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(0);
        }
        if (capture == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(1);
        }
        if (threadInfo == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(2);
        }
        if (timeline == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(3);
        }
        if (multiSelectionModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(4);
        }
        this.myThreadStateChartModel = new StateChartModel();
        this.myThreadStateTooltip = new CpuThreadsTooltip(timeline);
        if (capture.getType() == Cpu.CpuTraceType.ATRACE) {
            AtraceDataSeries<CpuProfilerStage.ThreadState> threadStateDataSeries = new AtraceDataSeries<CpuProfilerStage.ThreadState>((AtraceCpuCapture)capture, atraceCapture -> atraceCapture.getThreadStatesForThread(threadInfo.getId()));
            this.myThreadStateChartModel.addSeries(new RangedSeries(range, threadStateDataSeries));
            this.myThreadStateTooltip.setThread(threadInfo.getName(), threadStateDataSeries);
        }
        this.myCallChartModel = new CaptureDetails.CallChart(range, Collections.singletonList(capture.getCaptureNode(threadInfo.getId())), capture);
        this.myCapture = capture;
        this.mySelectionRange = range;
        this.myThreadInfo = threadInfo;
        this.myTraceEventTooltipBuilder = captureNode -> new CpuCaptureNodeTooltip(timeline, (CaptureNode)captureNode);
        this.myMultiSelectionModel = multiSelectionModel;
    }

    @NotNull
    public StateChartModel<CpuProfilerStage.ThreadState> getThreadStateChartModel() {
        StateChartModel<CpuProfilerStage.ThreadState> stateChartModel = this.myThreadStateChartModel;
        if (stateChartModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(5);
        }
        return stateChartModel;
    }

    @NotNull
    public CaptureDetails.CallChart getCallChartModel() {
        CaptureDetails.CallChart callChart = this.myCallChartModel;
        if (callChart == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(6);
        }
        return callChart;
    }

    @NotNull
    public CpuCapture getCapture() {
        CpuCapture cpuCapture = this.myCapture;
        if (cpuCapture == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(7);
        }
        return cpuCapture;
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CpuThreadTrackModel> getAnalysisModel() {
        CpuAnalysisChartModel<CpuThreadTrackModel> flameChart = new CpuAnalysisChartModel<CpuThreadTrackModel>(CpuAnalysisTabModel.Type.FLAME_CHART, this.mySelectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode);
        CpuAnalysisChartModel<CpuThreadTrackModel> topDown = new CpuAnalysisChartModel<CpuThreadTrackModel>(CpuAnalysisTabModel.Type.TOP_DOWN, this.mySelectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode);
        CpuAnalysisChartModel<CpuThreadTrackModel> bottomUp = new CpuAnalysisChartModel<CpuThreadTrackModel>(CpuAnalysisTabModel.Type.BOTTOM_UP, this.mySelectionRange, this.myCapture, CpuThreadTrackModel::getCaptureNode);
        flameChart.getDataSeries().add(this);
        topDown.getDataSeries().add(this);
        bottomUp.getDataSeries().add(this);
        CpuAnalysisModel<CpuThreadTrackModel> model = new CpuAnalysisModel<CpuThreadTrackModel>(this.myThreadInfo.getName(), "%d threads");
        model.addTabModel(flameChart);
        model.addTabModel(topDown);
        model.addTabModel(bottomUp);
        CpuAnalysisModel<CpuThreadTrackModel> cpuAnalysisModel = model;
        if (cpuAnalysisModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(8);
        }
        return cpuAnalysisModel;
    }

    public boolean isCompatibleWith(@NotNull SelectableTrackModel otherObj) {
        if (otherObj == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(9);
        }
        return otherObj instanceof CpuThreadTrackModel;
    }

    @NotNull
    public CpuThreadsTooltip getThreadStateTooltip() {
        CpuThreadsTooltip cpuThreadsTooltip = this.myThreadStateTooltip;
        if (cpuThreadsTooltip == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(10);
        }
        return cpuThreadsTooltip;
    }

    @NotNull
    public Function<CaptureNode, CpuCaptureNodeTooltip> getTraceEventTooltipBuilder() {
        Function<CaptureNode, CpuCaptureNodeTooltip> function = this.myTraceEventTooltipBuilder;
        if (function == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(11);
        }
        return function;
    }

    @NotNull
    public MultiSelectionModel<CpuAnalyzable> getMultiSelectionModel() {
        MultiSelectionModel<CpuAnalyzable> multiSelectionModel = this.myMultiSelectionModel;
        if (multiSelectionModel == null) {
            CpuThreadTrackModel.$$$reportNull$$$0(12);
        }
        return multiSelectionModel;
    }

    private Collection<CaptureNode> getCaptureNode() {
        assert (this.myCapture.containsThread(this.myThreadInfo.getId()));
        return Collections.singleton(this.myCapture.getCaptureNode(this.myThreadInfo.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiSelectionModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadTrackModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherObj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadTrackModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStateChartModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallChartModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapture";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStateTooltip";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceEventTooltipBuilder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiSelectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

