/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;

public enum ProfilingTechnology {
    ART_SAMPLED("Java Method Sample Recording", "Samples Java code using Android Runtime."),
    ART_INSTRUMENTED("Java Method Trace Recording", "Instruments Java code using Android Runtime."),
    ART_UNSPECIFIED("Java Method Recording", "Profiles Java code using Android Runtime."),
    SIMPLEPERF("C/C++ Function Recording", "Samples native code using simpleperf.", "Available for Android 8.0 (API level 26) and higher."),
    ATRACE("System Trace Recording", "Traces Java and native code at the Android platform level.", "Available for Android 7.0 (API level 24) and higher.");

    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExtraDescription;

    private ProfilingTechnology(@NotNull String name, String description, String extraDescription) {
        if (name == null) {
            ProfilingTechnology.$$$reportNull$$$0(0);
        }
        if (description == null) {
            ProfilingTechnology.$$$reportNull$$$0(1);
        }
        if (extraDescription == null) {
            ProfilingTechnology.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myDescription = description;
        this.myExtraDescription = extraDescription;
    }

    private ProfilingTechnology(String name, String description) {
        if (name == null) {
            ProfilingTechnology.$$$reportNull$$$0(3);
        }
        if (description == null) {
            ProfilingTechnology.$$$reportNull$$$0(4);
        }
        this(name, description, "");
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getLongDescription() {
        String string = String.format("<html>%s %s</html>", this.myDescription, this.myExtraDescription);
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public Cpu.CpuTraceType getType() {
        switch (this) {
            case ART_SAMPLED: {
                Cpu.CpuTraceType cpuTraceType = Cpu.CpuTraceType.ART;
                if (cpuTraceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(8);
                }
                return cpuTraceType;
            }
            case ART_INSTRUMENTED: {
                Cpu.CpuTraceType cpuTraceType = Cpu.CpuTraceType.ART;
                if (cpuTraceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(9);
                }
                return cpuTraceType;
            }
            case ART_UNSPECIFIED: {
                Cpu.CpuTraceType cpuTraceType = Cpu.CpuTraceType.ART;
                if (cpuTraceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(10);
                }
                return cpuTraceType;
            }
            case SIMPLEPERF: {
                Cpu.CpuTraceType cpuTraceType = Cpu.CpuTraceType.SIMPLEPERF;
                if (cpuTraceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(11);
                }
                return cpuTraceType;
            }
            case ATRACE: {
                Cpu.CpuTraceType cpuTraceType = Cpu.CpuTraceType.ATRACE;
                if (cpuTraceType == null) {
                    ProfilingTechnology.$$$reportNull$$$0(12);
                }
                return cpuTraceType;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public Cpu.CpuTraceMode getMode() {
        switch (this) {
            case ART_SAMPLED: {
                Cpu.CpuTraceMode cpuTraceMode = Cpu.CpuTraceMode.SAMPLED;
                if (cpuTraceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(13);
                }
                return cpuTraceMode;
            }
            case ART_INSTRUMENTED: {
                Cpu.CpuTraceMode cpuTraceMode = Cpu.CpuTraceMode.INSTRUMENTED;
                if (cpuTraceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(14);
                }
                return cpuTraceMode;
            }
            case ART_UNSPECIFIED: {
                Cpu.CpuTraceMode cpuTraceMode = Cpu.CpuTraceMode.UNSPECIFIED_MODE;
                if (cpuTraceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(15);
                }
                return cpuTraceMode;
            }
            case SIMPLEPERF: {
                Cpu.CpuTraceMode cpuTraceMode = Cpu.CpuTraceMode.SAMPLED;
                if (cpuTraceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(16);
                }
                return cpuTraceMode;
            }
            case ATRACE: {
                Cpu.CpuTraceMode cpuTraceMode = Cpu.CpuTraceMode.INSTRUMENTED;
                if (cpuTraceMode == null) {
                    ProfilingTechnology.$$$reportNull$$$0(17);
                }
                return cpuTraceMode;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    @NotNull
    public static ProfilingTechnology fromTypeAndMode(@NotNull Cpu.CpuTraceType type, @NotNull Cpu.CpuTraceMode mode) {
        if (type == null) {
            ProfilingTechnology.$$$reportNull$$$0(18);
        }
        if (mode == null) {
            ProfilingTechnology.$$$reportNull$$$0(19);
        }
        switch (type) {
            case ART: {
                if (mode == Cpu.CpuTraceMode.SAMPLED) {
                    ProfilingTechnology profilingTechnology = ART_SAMPLED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(20);
                    }
                    return profilingTechnology;
                }
                if (mode == Cpu.CpuTraceMode.INSTRUMENTED) {
                    ProfilingTechnology profilingTechnology = ART_INSTRUMENTED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(21);
                    }
                    return profilingTechnology;
                }
                ProfilingTechnology profilingTechnology = ART_UNSPECIFIED;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(22);
                }
                return profilingTechnology;
            }
            case SIMPLEPERF: {
                ProfilingTechnology profilingTechnology = SIMPLEPERF;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(23);
                }
                return profilingTechnology;
            }
            case ATRACE: {
                ProfilingTechnology profilingTechnology = ATRACE;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(24);
                }
                return profilingTechnology;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }

    @NotNull
    public static ProfilingTechnology fromConfig(@NotNull ProfilingConfiguration config) {
        if (config == null) {
            ProfilingTechnology.$$$reportNull$$$0(25);
        }
        return ProfilingTechnology.fromTypeAndMode(config.getTraceType(), config.getMode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraDescription";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ProfilingTechnology";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ProfilingTechnology";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescription";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypeAndMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fromTypeAndMode";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fromConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

