/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.trackgroup.SelectableTrackModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CaptureNodeAnalysisModel
implements CpuAnalyzable<CaptureNodeAnalysisModel> {
    @NotNull
    private final CaptureNode myNode;
    @NotNull
    private final CpuCapture myCapture;

    public CaptureNodeAnalysisModel(@NotNull CaptureNode node, @NotNull CpuCapture capture) {
        if (node == null) {
            CaptureNodeAnalysisModel.$$$reportNull$$$0(0);
        }
        if (capture == null) {
            CaptureNodeAnalysisModel.$$$reportNull$$$0(1);
        }
        this.myNode = node;
        this.myCapture = capture;
    }

    @NotNull
    public CaptureNode getNode() {
        CaptureNode captureNode = this.myNode;
        if (captureNode == null) {
            CaptureNodeAnalysisModel.$$$reportNull$$$0(2);
        }
        return captureNode;
    }

    @NotNull
    public Range getNodeRange() {
        return new Range((double)this.myNode.getStart(), (double)this.myNode.getEnd());
    }

    @Override
    @NotNull
    public CpuAnalysisModel<CaptureNodeAnalysisModel> getAnalysisModel() {
        Range nodeRange = this.getNodeRange();
        Set<CaptureNode> nodes = Collections.singleton(this.myNode);
        CpuAnalysisChartModel<CaptureNodeAnalysisModel> flameChart = new CpuAnalysisChartModel<CaptureNodeAnalysisModel>(CpuAnalysisTabModel.Type.FLAME_CHART, nodeRange, this.myCapture, unused -> nodes);
        CpuAnalysisChartModel<CaptureNodeAnalysisModel> topDown = new CpuAnalysisChartModel<CaptureNodeAnalysisModel>(CpuAnalysisTabModel.Type.TOP_DOWN, nodeRange, this.myCapture, unused -> nodes);
        CpuAnalysisChartModel<CaptureNodeAnalysisModel> bottomUp = new CpuAnalysisChartModel<CaptureNodeAnalysisModel>(CpuAnalysisTabModel.Type.BOTTOM_UP, nodeRange, this.myCapture, unused -> nodes);
        flameChart.getDataSeries().add(this);
        topDown.getDataSeries().add(this);
        bottomUp.getDataSeries().add(this);
        CpuAnalysisModel<CaptureNodeAnalysisModel> model = new CpuAnalysisModel<CaptureNodeAnalysisModel>(this.myNode.getData().getName(), "%d events");
        model.addTabModel(flameChart);
        model.addTabModel(topDown);
        model.addTabModel(bottomUp);
        CpuAnalysisModel<CaptureNodeAnalysisModel> cpuAnalysisModel = model;
        if (cpuAnalysisModel == null) {
            CaptureNodeAnalysisModel.$$$reportNull$$$0(3);
        }
        return cpuAnalysisModel;
    }

    public boolean isCompatibleWith(@NotNull SelectableTrackModel otherObj) {
        if (otherObj == null) {
            CaptureNodeAnalysisModel.$$$reportNull$$$0(4);
        }
        return otherObj instanceof CaptureNodeAnalysisModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherObj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

