/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.PercentAxisFormatter;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisChartModel<T>
extends CpuAnalysisTabModel<T> {
    private static final Map<CpuAnalysisTabModel.Type, CaptureDetails.Type> TAB_TYPE_TO_DETAIL_TYPE = ImmutableMap.of((Object)((Object)CpuAnalysisTabModel.Type.FLAME_CHART), (Object)((Object)CaptureDetails.Type.FLAME_CHART), (Object)((Object)CpuAnalysisTabModel.Type.TOP_DOWN), (Object)((Object)CaptureDetails.Type.TOP_DOWN), (Object)((Object)CpuAnalysisTabModel.Type.BOTTOM_UP), (Object)((Object)CaptureDetails.Type.BOTTOM_UP));
    private final CpuCapture myCapture;
    private final Range mySelectionRange;
    private final CaptureDetails.Type myDetailsType;
    private final AxisComponentModel myAxisComponentModel;
    private final Function<T, Collection<CaptureNode>> myCaptureNodesExtractor;
    @NotNull
    private final Range myClampedSelectionRange;
    @NotNull
    private final Range myCaptureConvertedRange;
    @NotNull
    private final AspectObserver myObserver;
    @NotNull
    private final AspectModel<Aspect> myAspectModel;
    @NotNull
    private ClockType myClockType;

    public CpuAnalysisChartModel(@NotNull CpuAnalysisTabModel.Type tabType, @NotNull Range selectionRange, @NotNull CpuCapture capture, @NotNull Function<T, Collection<CaptureNode>> captureNodesExtractor) {
        if (tabType == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(0);
        }
        if (selectionRange == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(1);
        }
        if (capture == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(2);
        }
        if (captureNodesExtractor == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(3);
        }
        super(tabType);
        this.myObserver = new AspectObserver();
        this.myAspectModel = new AspectModel();
        assert (TAB_TYPE_TO_DETAIL_TYPE.containsKey((Object)tabType));
        this.myCapture = capture;
        this.mySelectionRange = selectionRange;
        this.myClampedSelectionRange = new Range(selectionRange);
        this.myCaptureConvertedRange = new Range();
        selectionRange.addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeSync);
        this.myClampedSelectionRange.addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::updateCaptureConvertedRange);
        this.myCaptureConvertedRange.addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::updateSelectionRange);
        this.myDetailsType = TAB_TYPE_TO_DETAIL_TYPE.get((Object)tabType);
        this.myCaptureNodesExtractor = captureNodesExtractor;
        this.myAxisComponentModel = new ClampedAxisComponentModel.Builder(this.myClampedSelectionRange, (BaseAxisFormatter)new PercentAxisFormatter(5, 10)).build();
        this.setClockType(ClockType.GLOBAL);
    }

    private void selectionRangeSync() {
        this.myClampedSelectionRange.set(this.mySelectionRange);
    }

    @NotNull
    public CaptureDetails createDetails() {
        CaptureDetails captureDetails = this.applyFilterAndCreateDetails(Filter.EMPTY_FILTER).getCaptureDetails();
        if (captureDetails == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(4);
        }
        return captureDetails;
    }

    @NotNull
    public CaptureDetailsWithFilterResult applyFilterAndCreateDetails(@NotNull Filter filter) {
        if (filter == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(5);
        }
        List<CaptureNode> nodes = this.collectCaptureNodes();
        FilterResult combinedResult = nodes.stream().map(node -> node.applyFilter(filter)).reduce(FilterResult::combine).orElseGet(FilterResult::new);
        return new CaptureDetailsWithFilterResult(this.myDetailsType.build(this.myCaptureConvertedRange, nodes, this.myCapture), combinedResult);
    }

    @NotNull
    public CaptureDetails.Type getDetailsType() {
        CaptureDetails.Type type = this.myDetailsType;
        if (type == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(6);
        }
        return type;
    }

    @NotNull
    public AxisComponentModel getAxisComponentModel() {
        AxisComponentModel axisComponentModel = this.myAxisComponentModel;
        if (axisComponentModel == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(7);
        }
        return axisComponentModel;
    }

    public boolean isCaptureDualClock() {
        return this.myCapture.isDualClock();
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        ImmutableList immutableList = ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
        if (immutableList == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @VisibleForTesting
    public Range getCaptureConvertedRange() {
        return this.myCaptureConvertedRange;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myClockType;
        if (clockType == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(9);
        }
        return clockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(10);
        }
        if (this.myClockType == clockType || !this.isCaptureDualClock() && clockType == ClockType.THREAD) {
            return;
        }
        this.myClockType = clockType;
        this.myCapture.updateClockType(clockType);
        this.updateCaptureConvertedRange();
        this.myAspectModel.changed((Enum)Aspect.CLOCK_TYPE);
    }

    @NotNull
    public AspectModel<Aspect> getAspectModel() {
        AspectModel<Aspect> aspectModel = this.myAspectModel;
        if (aspectModel == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(11);
        }
        return aspectModel;
    }

    private void updateCaptureConvertedRange() {
        Range selection = this.myClampedSelectionRange;
        ClockType clockType = this.getClockType();
        if (clockType == ClockType.GLOBAL || this.getDataSeries().isEmpty()) {
            this.setConvertedRange(selection);
            return;
        }
        CaptureNode node = this.myCaptureNodesExtractor.apply(this.getDataSeries().get(0)).iterator().next();
        double convertedMin = (double)node.getStartThread() + node.threadGlobalRatio() * (selection.getMin() - (double)node.getStartGlobal());
        double convertedMax = convertedMin + node.threadGlobalRatio() * selection.getLength();
        this.setConvertedRange(new Range(convertedMin, convertedMax));
    }

    private void updateSelectionRange() {
        ClockType clockType = this.getClockType();
        if (clockType == ClockType.GLOBAL || this.getDataSeries().isEmpty()) {
            this.setSelectionRange(this.myCaptureConvertedRange);
            return;
        }
        CaptureNode node = this.myCaptureNodesExtractor.apply(this.getDataSeries().get(0)).iterator().next();
        double threadToGlobal = 1.0 / node.threadGlobalRatio();
        double convertedMin = (double)node.getStartGlobal() + threadToGlobal * (this.myCaptureConvertedRange.getMin() - (double)node.getStartThread());
        double convertedMax = convertedMin + threadToGlobal * this.myCaptureConvertedRange.getLength();
        this.setSelectionRange(new Range(convertedMin, convertedMax));
    }

    private void setSelectionRange(Range range) {
        if (!this.myClampedSelectionRange.isSameAs(range)) {
            this.myClampedSelectionRange.set(range);
        }
    }

    private void setConvertedRange(Range range) {
        if (!this.myCaptureConvertedRange.isSameAs(range)) {
            this.myCaptureConvertedRange.set(range);
        }
    }

    @NotNull
    private List<CaptureNode> collectCaptureNodes() {
        List<CaptureNode> list = this.getDataSeries().stream().map(this.myCaptureNodesExtractor).flatMap(Collection::stream).collect(Collectors.toList());
        if (list == null) {
            CpuAnalysisChartModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureNodesExtractor";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetails";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetailsType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAxisComponentModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspectModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCaptureNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFilterAndCreateDetails";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class CaptureDetailsWithFilterResult {
        @NotNull
        private final CaptureDetails myCaptureDetails;
        @NotNull
        private final FilterResult myFilterResult;

        private CaptureDetailsWithFilterResult(@NotNull CaptureDetails captureDetails, @NotNull FilterResult filterResult) {
            if (captureDetails == null) {
                CaptureDetailsWithFilterResult.$$$reportNull$$$0(0);
            }
            if (filterResult == null) {
                CaptureDetailsWithFilterResult.$$$reportNull$$$0(1);
            }
            this.myCaptureDetails = captureDetails;
            this.myFilterResult = filterResult;
        }

        @NotNull
        CaptureDetails getCaptureDetails() {
            CaptureDetails captureDetails = this.myCaptureDetails;
            if (captureDetails == null) {
                CaptureDetailsWithFilterResult.$$$reportNull$$$0(2);
            }
            return captureDetails;
        }

        @NotNull
        FilterResult getFilterResult() {
            FilterResult filterResult = this.myFilterResult;
            if (filterResult == null) {
                CaptureDetailsWithFilterResult.$$$reportNull$$$0(3);
            }
            return filterResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureDetails";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterResult";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel$CaptureDetailsWithFilterResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/analysis/CpuAnalysisChartModel$CaptureDetailsWithFilterResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaptureDetails";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilterResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Aspect {
        CLOCK_TYPE;

    }
}

