/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameManager;
import com.android.tools.profilers.cpu.atrace.AtraceParser;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AtraceCpuCapture
extends CpuCapture {
    private final Map<Integer, List<SeriesData<CpuProfilerStage.ThreadState>>> myThreadStateDataSeries;
    private final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> myCpuThreadSliceInfoStates;
    private final List<SeriesData<Long>> myCpuUtilizationSeries;
    private final int myRenderThreadId;
    private final boolean myIsMissingData;
    private final AtraceFrameManager myFrameManager;

    public AtraceCpuCapture(AtraceParser parser, AtraceFrameManager frameManager, long traceId) {
        super(parser, traceId, Cpu.CpuTraceType.ATRACE);
        this.myThreadStateDataSeries = parser.getThreadStateDataSeries();
        this.myCpuThreadSliceInfoStates = parser.getCpuThreadSliceInfoStates();
        this.myCpuUtilizationSeries = parser.getCpuUtilizationSeries();
        this.myRenderThreadId = parser.getRenderThreadId();
        this.myIsMissingData = parser.isMissingData();
        this.myFrameManager = frameManager;
    }

    @NotNull
    public List<SeriesData<CpuProfilerStage.ThreadState>> getThreadStatesForThread(int threadId) {
        List list = this.myThreadStateDataSeries.getOrDefault(threadId, new ArrayList());
        if (list == null) {
            AtraceCpuCapture.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<SeriesData<CpuThreadSliceInfo>> getCpuThreadSliceInfoStates(int cpu) {
        List list = this.myCpuThreadSliceInfoStates.getOrDefault(cpu, new ArrayList());
        if (list == null) {
            AtraceCpuCapture.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<SeriesData<Long>> getCpuUtilizationSeries() {
        List<SeriesData<Long>> list = this.myCpuUtilizationSeries;
        if (list == null) {
            AtraceCpuCapture.$$$reportNull$$$0(2);
        }
        return list;
    }

    public int getCpuCount() {
        return this.myCpuThreadSliceInfoStates.size();
    }

    public boolean isMissingData() {
        return this.myIsMissingData;
    }

    public List<SeriesData<AtraceFrame>> getFrames(AtraceFrame.FrameThread threadType) {
        return this.myFrameManager.getFrames(threadType);
    }

    public int getRenderThreadId() {
        return this.myRenderThreadId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/profilers/cpu/atrace/AtraceCpuCapture";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStatesForThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuThreadSliceInfoStates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuUtilizationSeries";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

