/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.CpuFramesModel;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.SliceStream;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.ProcessModel;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;

public class AtraceFrameManager {
    @NotNull
    private final Function<Double, Long> myBootClockSecondsToMonoUs;
    private final List<AtraceFrame> myMainThreadFrames;
    private final List<AtraceFrame> myRenderThreadFrames;

    public AtraceFrameManager(@NotNull ProcessModel process, @NotNull Function<Double, Long> bootClockSecondsToMonoUs, int renderThreadId) {
        if (process == null) {
            AtraceFrameManager.$$$reportNull$$$0(0);
        }
        if (bootClockSecondsToMonoUs == null) {
            AtraceFrameManager.$$$reportNull$$$0(1);
        }
        this.myBootClockSecondsToMonoUs = bootClockSecondsToMonoUs;
        this.myMainThreadFrames = this.buildFramesList(AtraceFrame.FrameThread.MAIN, process, process.getId());
        this.myRenderThreadFrames = this.buildFramesList(AtraceFrame.FrameThread.RENDER, process, renderThreadId);
        this.findAssociatedFrames();
    }

    private void findAssociatedFrames() {
        int mainFramesIterator = 0;
        int renderFramesIterator = 0;
        while (mainFramesIterator < this.myMainThreadFrames.size() && renderFramesIterator < this.myRenderThreadFrames.size()) {
            AtraceFrame mainThreadFrame = this.myMainThreadFrames.get(mainFramesIterator);
            AtraceFrame renderThreadFrame = this.myRenderThreadFrames.get(renderFramesIterator);
            if (renderThreadFrame == AtraceFrame.EMPTY || renderThreadFrame.getEndUs() < mainThreadFrame.getEndUs()) {
                ++renderFramesIterator;
                continue;
            }
            if (mainThreadFrame == AtraceFrame.EMPTY || renderThreadFrame.getStartUs() > mainThreadFrame.getEndUs() || renderThreadFrame.getStartUs() < mainThreadFrame.getStartUs()) {
                ++mainFramesIterator;
                continue;
            }
            mainThreadFrame.setAssociatedFrame(renderThreadFrame);
            renderThreadFrame.setAssociatedFrame(mainThreadFrame);
            ++mainFramesIterator;
            ++renderFramesIterator;
        }
    }

    @NotNull
    private List<AtraceFrame> buildFramesList(AtraceFrame.FrameThread frameThread, ProcessModel processModel, int threadId) {
        ArrayList<AtraceFrame> frames = new ArrayList<AtraceFrame>();
        Optional<ThreadModel> activeThread = processModel.getThreads().stream().filter(thread2 -> thread2.getId() == threadId).findFirst();
        if (!activeThread.isPresent()) {
            ArrayList<AtraceFrame> arrayList = frames;
            if (arrayList == null) {
                AtraceFrameManager.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        new SliceStream(activeThread.get().getSlices()).matchPattern(Pattern.compile(frameThread.getIdentifierRegEx())).enumerate(sliceGroup -> {
            AtraceFrame frame = new AtraceFrame(((ThreadModel)activeThread.get()).getId(), this.myBootClockSecondsToMonoUs, CpuFramesModel.SLOW_FRAME_RATE_US, frameThread);
            double startTime = sliceGroup.getStartTime();
            double endTime = sliceGroup.getEndTime();
            frame.addSlice((SliceGroup)sliceGroup, new Range(startTime, endTime));
            frames.add(frame);
            return SliceStream.EnumerationResult.SKIP_CHILDREN;
        });
        ArrayList<AtraceFrame> arrayList = frames;
        if (arrayList == null) {
            AtraceFrameManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @VisibleForTesting
    List<AtraceFrame> getFramesList(@NotNull AtraceFrame.FrameThread thread2) {
        if (thread2 == null) {
            AtraceFrameManager.$$$reportNull$$$0(4);
        }
        switch (thread2) {
            case MAIN: {
                return this.myMainThreadFrames;
            }
            case RENDER: {
                return this.myRenderThreadFrames;
            }
        }
        return new ArrayList<AtraceFrame>();
    }

    @NotNull
    public List<SeriesData<AtraceFrame>> getFrames(@NotNull AtraceFrame.FrameThread thread2) {
        if (thread2 == null) {
            AtraceFrameManager.$$$reportNull$$$0(5);
        }
        ArrayList<SeriesData<AtraceFrame>> framesSeries = new ArrayList<SeriesData<AtraceFrame>>();
        List<AtraceFrame> framesList = this.getFramesList(thread2);
        for (int i = 1; i < framesList.size(); ++i) {
            AtraceFrame current = framesList.get(i);
            AtraceFrame past = framesList.get(i - 1);
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.myBootClockSecondsToMonoUs.apply(past.getTotalRangeSeconds().getMin()).longValue(), (Object)past));
            if (!(past.getTotalRangeSeconds().getMax() < current.getTotalRangeSeconds().getMin())) continue;
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.myBootClockSecondsToMonoUs.apply(past.getTotalRangeSeconds().getMax()).longValue(), (Object)AtraceFrame.EMPTY));
        }
        if (!framesList.isEmpty()) {
            AtraceFrame lastFrame = framesList.get(framesList.size() - 1);
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.myBootClockSecondsToMonoUs.apply(lastFrame.getTotalRangeSeconds().getMin()).longValue(), (Object)lastFrame));
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.myBootClockSecondsToMonoUs.apply(lastFrame.getTotalRangeSeconds().getMax()).longValue(), (Object)AtraceFrame.EMPTY));
        }
        ArrayList<SeriesData<AtraceFrame>> arrayList = framesSeries;
        if (arrayList == null) {
            AtraceFrameManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootClockSecondsToMonoUs";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceFrameManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceFrameManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFramesList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFramesList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

