/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.common.DataVisualizationColors;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.nodemodel.AtraceNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class AtraceNodeModelHChartColors {
    AtraceNodeModelHChartColors() {
    }

    private static void validateModel(@NotNull CaptureNodeModel model) {
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(0);
        }
        if (!(model instanceof AtraceNodeModel)) {
            throw new IllegalStateException("Model must be an instance of AtraceNodeModel.");
        }
    }

    static Color getIdleCpuColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        Color color;
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(1);
        }
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            color = JBColor.isBright() ? ColorUtil.darker((Color)DataVisualizationColors.INSTANCE.getColor(index, isFocused), (int)5) : ColorUtil.brighter((Color)DataVisualizationColors.INSTANCE.getColor(index, isFocused), (int)5);
            if (isDeselected && !isFocused) {
                color = DataVisualizationColors.INSTANCE.toGrayscale(color);
            }
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER_IDLE : ProfilerColors.CPU_FLAMECHART_APP_IDLE;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getFillColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isUnmatched, boolean isFocused, boolean isDeselected) {
        Color color;
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(2);
        }
        AtraceNodeModelHChartColors.validateModel(model);
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            color = DataVisualizationColors.INSTANCE.getColor(index, isFocused);
            if (isDeselected && !isFocused) {
                color = DataVisualizationColors.INSTANCE.toGrayscale(color);
            }
        } else {
            color = isFocused ? ProfilerColors.CPU_FLAMECHART_APP_HOVER : ProfilerColors.CPU_FLAMECHART_APP;
        }
        return isUnmatched ? CaptureNodeHRenderer.toUnmatchColor(color) : color;
    }

    static Color getTextColor(@NotNull CaptureNodeModel model, CaptureDetails.Type chartType, boolean isDeselected) {
        if (model == null) {
            AtraceNodeModelHChartColors.$$$reportNull$$$0(3);
        }
        if (chartType == CaptureDetails.Type.CALL_CHART) {
            int index = model.getFullName().hashCode();
            return isDeselected ? DataVisualizationColors.INSTANCE.getFontColor("Gray") : DataVisualizationColors.INSTANCE.getFontColor(index);
        }
        return DataVisualizationColors.DEFAULT_DARK_TEXT_COLOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/AtraceNodeModelHChartColors";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validateModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdleCpuColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFillColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

