/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.capturedetails.CpuChartTooltipView;
import com.android.tools.profilers.cpu.capturedetails.CpuTraceEventTooltipView;
import com.android.tools.profilers.cpu.nodemodel.AtraceNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.ui.DoubleClickListener;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChartDetailsView
extends CaptureDetailsView {
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final AspectObserver myObserver;

    private ChartDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.ChartDetails chartDetails) {
        if (profilersView == null) {
            ChartDetailsView.$$$reportNull$$$0(0);
        }
        if (chartDetails == null) {
            ChartDetailsView.$$$reportNull$$$0(1);
        }
        super(profilersView);
        this.myObserver = new AspectObserver();
        if (chartDetails.getNode() == null) {
            this.myPanel = ChartDetailsView.getNoDataForThread();
            return;
        }
        this.myPanel = new JPanel(new CardLayout());
        this.myPanel.add((Component)ChartDetailsView.getNoDataForRange(), "Empty content");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ChartDetailsView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    protected HTreeChart<CaptureNode> createChart(@NotNull CaptureDetails.ChartDetails chartDetails, @NotNull Range globalRange, @NotNull Range range) {
        if (chartDetails == null) {
            ChartDetailsView.$$$reportNull$$$0(3);
        }
        if (globalRange == null) {
            ChartDetailsView.$$$reportNull$$$0(4);
        }
        if (range == null) {
            ChartDetailsView.$$$reportNull$$$0(5);
        }
        CaptureDetails.Type type = chartDetails.getType();
        CaptureNode node = chartDetails.getNode();
        HTreeChart.Orientation orientation = type == CaptureDetails.Type.CALL_CHART ? HTreeChart.Orientation.TOP_DOWN : HTreeChart.Orientation.BOTTOM_UP;
        HTreeChart chart = new HTreeChart.Builder((HNode)node, range, (HRenderer)new CaptureNodeHRenderer(type)).setGlobalXRange(globalRange).setOrientation(orientation).setRootVisible(false).build();
        if (node != null) {
            if (node.getData().getId().isEmpty()) {
                node = (CaptureNode)node.getFirstChild();
            }
            if (node.getData() instanceof AtraceNodeModel) {
                if (type == CaptureDetails.Type.CALL_CHART) {
                    chart.addMouseMotionListener((MouseMotionListener)new CpuTraceEventTooltipView((HTreeChart<CaptureNode>)chart, this.myProfilersView.getComponent(), ProfilerColors.CPU_USAGE_CAPTURED, ProfilerColors.CPU_TRACE_IDLE));
                } else {
                    chart.addMouseMotionListener((MouseMotionListener)new CpuTraceEventTooltipView((HTreeChart<CaptureNode>)chart, this.myProfilersView.getComponent(), ProfilerColors.CPU_FLAMECHART_APP, ProfilerColors.CPU_FLAMECHART_APP_IDLE));
                }
            } else {
                chart.addMouseMotionListener((MouseMotionListener)new CpuChartTooltipView((HTreeChart<CaptureNode>)chart, this.myProfilersView.getStudioProfilers().getTimeline().getDataRange(), this.myProfilersView.getComponent()));
            }
        }
        if (chartDetails.getCapture().getType() != Cpu.CpuTraceType.ATRACE) {
            CodeNavigator navigator = this.myProfilersView.getStudioProfilers().getStage().getStudioProfilers().getIdeServices().getCodeNavigator();
            CodeNavigationHandler handler = new CodeNavigationHandler((HTreeChart<CaptureNode>)chart, navigator);
            chart.addMouseListener((MouseListener)handler);
            this.myProfilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart, navigator, () -> handler.getCodeLocation());
        }
        HTreeChart hTreeChart = chart;
        if (hTreeChart == null) {
            ChartDetailsView.$$$reportNull$$$0(6);
        }
        return hTreeChart;
    }

    @Nullable
    protected static CodeLocation modelToCodeLocation(CaptureNodeModel model) {
        if (model instanceof CppFunctionModel) {
            CppFunctionModel nativeFunction = (CppFunctionModel)model;
            return new CodeLocation.Builder(nativeFunction.getClassOrNamespace()).setMethodName(nativeFunction.getName()).setMethodParameters(nativeFunction.getParameters()).setNativeCode(true).setFileName(nativeFunction.getFileName()).setNativeVAddress(nativeFunction.getVAddress()).build();
        }
        if (model instanceof JavaMethodModel) {
            JavaMethodModel javaMethod = (JavaMethodModel)model;
            return new CodeLocation.Builder(javaMethod.getClassName()).setMethodName(javaMethod.getName()).setMethodSignature(javaMethod.getSignature()).setNativeCode(false).build();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chartDetails";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CodeNavigationHandler
    extends MouseAdapter {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        private Point myLastPopupPoint;

        CodeNavigationHandler(@NotNull HTreeChart<CaptureNode> chart, final @NotNull CodeNavigator navigator) {
            if (chart == null) {
                CodeNavigationHandler.$$$reportNull$$$0(0);
            }
            if (navigator == null) {
                CodeNavigationHandler.$$$reportNull$$$0(1);
            }
            this.myChart = chart;
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.setLastPopupPoint(event);
                    CodeLocation codeLocation = this.getCodeLocation();
                    if (codeLocation != null) {
                        navigator.navigate(codeLocation);
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView$CodeNavigationHandler$1", "onDoubleClick"));
                }
            }.installOn(chart);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.setLastPopupPoint(e);
            }
        }

        private void setLastPopupPoint(MouseEvent e) {
            this.myLastPopupPoint = e.getPoint();
        }

        @Nullable
        private CodeLocation getCodeLocation() {
            CaptureNode n = (CaptureNode)this.myChart.getNodeAt(this.myLastPopupPoint);
            if (n == null) {
                return null;
            }
            return ChartDetailsView.modelToCodeLocation(n.getData());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "chart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigator";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView$CodeNavigationHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FlameChartDetailsView
    extends ChartDetailsView {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final CaptureDetails.FlameChart myFlameChart;
        @NotNull
        private final Range myMasterRange;

        public FlameChartDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.FlameChart flameChart) {
            if (profilersView == null) {
                FlameChartDetailsView.$$$reportNull$$$0(0);
            }
            if (flameChart == null) {
                FlameChartDetailsView.$$$reportNull$$$0(1);
            }
            super(profilersView, flameChart);
            this.myFlameChart = flameChart;
            this.myMasterRange = new Range(this.myFlameChart.getRange());
            this.myChart = this.createChart(this.myFlameChart, this.myFlameChart.getRange(), this.myMasterRange);
            if (this.myFlameChart.getNode() == null) {
                return;
            }
            this.myPanel.add((Component)this.createChartPanel(), "Content");
            this.myFlameChart.getAspect().addDependency(this.myObserver).onChange((Enum)CaptureDetails.FlameChart.Aspect.NODE, this::nodeChanged);
            this.nodeChanged();
        }

        @NotNull
        private JPanel createChartPanel() {
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(this.myFlameChart.getRange(), this.myMasterRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
            panel.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            panel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
            panel.add((Component)this.myChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), new TabularLayout.Constraint(0, 1));
            panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
            JPanel jPanel = panel;
            if (jPanel == null) {
                FlameChartDetailsView.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private void nodeChanged() {
            FlameChartDetailsView.switchCardLayout(this.myPanel, this.myFlameChart.getNode() == null);
            this.myChart.setHTree((HNode)this.myFlameChart.getNode());
            this.myMasterRange.set(this.myFlameChart.getRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilersView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flameChart";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView$FlameChartDetailsView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView$FlameChartDetailsView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChartPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class CallChartDetailsView
    extends ChartDetailsView {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final CaptureDetails.CallChart myCallChart;

        public CallChartDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.CallChart callChart) {
            if (profilersView == null) {
                CallChartDetailsView.$$$reportNull$$$0(0);
            }
            if (callChart == null) {
                CallChartDetailsView.$$$reportNull$$$0(1);
            }
            super(profilersView, callChart);
            this.myCallChart = callChart;
            this.myChart = this.createChart(this.myCallChart, callChart.getCapture().getRange(), profilersView.getStudioProfilers().getTimeline().getSelectionRange());
            if (this.myCallChart.getNode() == null) {
                return;
            }
            this.myPanel.add((Component)this.createChartPanel(), "Content");
            this.myCallChart.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::callChartRangeChanged);
            this.callChartRangeChanged();
        }

        @NotNull
        private JPanel createChartPanel() {
            Range selectionRange = this.myProfilersView.getStudioProfilers().getTimeline().getSelectionRange();
            Range captureRange = this.myCallChart.getCapture().getRange();
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(captureRange, selectionRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            AxisComponent axis = CallChartDetailsView.createAxis(selectionRange, this.myProfilersView.getStudioProfilers().getTimeline().getDataRange());
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
            panel.add((Component)axis, new TabularLayout.Constraint(0, 0));
            panel.add((Component)this.myChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), new TabularLayout.Constraint(0, 1));
            panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
            JPanel jPanel = panel;
            if (jPanel == null) {
                CallChartDetailsView.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private void callChartRangeChanged() {
            CaptureNode node = this.myCallChart.getNode();
            assert (node != null);
            Range intersection = this.myCallChart.getRange().getIntersection(new Range((double)node.getStart(), (double)node.getEnd()));
            CallChartDetailsView.switchCardLayout(this.myPanel, intersection.isEmpty() || intersection.getLength() == 0.0);
        }

        private static AxisComponent createAxis(@NotNull Range range, @NotNull Range globalRange) {
            if (range == null) {
                CallChartDetailsView.$$$reportNull$$$0(3);
            }
            if (globalRange == null) {
                CallChartDetailsView.$$$reportNull$$$0(4);
            }
            ResizingAxisComponentModel axisModel = new ResizingAxisComponentModel.Builder(range, (BaseAxisFormatter)new TimeAxisFormatter(1, 10, 1)).setGlobalRange(globalRange).build();
            final AxisComponent axis = new AxisComponent((AxisComponentModel)axisModel, AxisComponent.AxisOrientation.BOTTOM);
            axis.setShowAxisLine(false);
            axis.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
            axis.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    axis.setMarkerLengths(axis.getHeight(), 0);
                    axis.repaint();
                }
            });
            return axis;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilersView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callChart";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView$CallChartDetailsView";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/ChartDetailsView$CallChartDetailsView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChartPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createAxis";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

