/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapDumpInstanceObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gnu.trove.TLongObjectHashMap;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapDumpCaptureObject
implements CaptureObject {
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final FeatureTracker myFeatureTracker;
    @NotNull
    private final Map<Integer, HeapSet> myHeapSets;
    @NotNull
    private final TLongObjectHashMap<InstanceObject> myInstanceIndex;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final Memory.HeapDumpInfo myHeapDumpInfo;
    @Nullable
    private final ProguardMap myProguardMap;
    @Nullable
    private volatile Snapshot mySnapshot;
    private volatile boolean myIsLoadingError;
    private boolean myHasNativeAllocations;
    @NotNull
    private final MemoryProfilerStage myStage;
    private final Set<CaptureObjectInstanceFilter> mySupportedInstanceFilters;
    private final Set<CaptureObjectInstanceFilter> myCurrentInstanceFilters;
    private final ExecutorService myExecutorService;

    public HeapDumpCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.HeapDumpInfo heapDumpInfo, @Nullable ProguardMap proguardMap, @NotNull FeatureTracker featureTracker, @NotNull MemoryProfilerStage stage) {
        if (client == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(0);
        }
        if (session == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(1);
        }
        if (heapDumpInfo == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(2);
        }
        if (featureTracker == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(3);
        }
        if (stage == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(4);
        }
        this.myHeapSets = new HashMap<Integer, HeapSet>();
        this.myInstanceIndex = new TLongObjectHashMap();
        this.myClassDb = new ClassDb();
        this.myIsLoadingError = false;
        this.myCurrentInstanceFilters = new HashSet<CaptureObjectInstanceFilter>();
        this.myExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("memory-heapdump-instancefilters").build());
        this.myClient = client;
        this.mySession = session;
        this.myHeapDumpInfo = heapDumpInfo;
        this.myProguardMap = proguardMap;
        this.myFeatureTracker = featureTracker;
        this.myStage = stage;
        this.mySupportedInstanceFilters = ImmutableSet.of((Object)new ActivityFragmentLeakInstanceFilter(), (Object)new ProjectClassesInstanceFilter(this.myStage.getStudioProfilers().getIdeServices()));
    }

    @Override
    @NotNull
    public String getName() {
        return "Heap Dump";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "hprof";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        if (outputStream == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(5);
        }
        MemoryProfiler.saveHeapDumpToFile(this.myClient, this.mySession, this.myHeapDumpInfo, outputStream, this.myFeatureTracker);
    }

    @VisibleForTesting
    @NotNull
    ClassDb getClassDb() {
        ClassDb classDb = this.myClassDb;
        if (classDb == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(6);
        }
        return classDb;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        Snapshot snapshot = this.mySnapshot;
        if (snapshot == null) {
            List<HeapSet> list = Collections.emptyList();
            if (list == null) {
                HeapDumpCaptureObject.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection<HeapSet> collection = this.myHeapSets.values();
        if (collection == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this.myHeapSets.getOrDefault(heapId, null);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Snapshot snapshot = this.mySnapshot;
        if (snapshot == null) {
            Stream<InstanceObject> stream = Stream.empty();
            if (stream == null) {
                HeapDumpCaptureObject.$$$reportNull$$$0(9);
            }
            return stream;
        }
        Stream<InstanceObject> stream = this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
        if (stream == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myHeapDumpInfo.getStartTime();
    }

    @Override
    public long getEndTimeNs() {
        return this.myHeapDumpInfo.getEndTime();
    }

    public boolean getHasNativeAllocations() {
        return this.myHasNativeAllocations;
    }

    @Override
    public ClassDb getClassDatabase() {
        return this.myClassDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        HeapSet heapSet;
        Transport.BytesResponse response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myHeapDumpInfo.getStartTime())).build());
        if (response.getContents() == ByteString.EMPTY) {
            this.myIsLoadingError = true;
            return false;
        }
        InMemoryBuffer buffer = new InMemoryBuffer(response.getContents().asReadOnlyByteBuffer());
        NativeRegistryPostProcessor nativeRegistryPostProcessor = new NativeRegistryPostProcessor();
        Snapshot snapshot = this.myProguardMap != null ? Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)this.myProguardMap, Collections.singletonList(nativeRegistryPostProcessor)) : Snapshot.createSnapshot((DataBuffer)buffer, (ProguardMap)new ProguardMap(), Collections.singletonList(nativeRegistryPostProcessor));
        snapshot.computeDominators();
        this.myHasNativeAllocations = nativeRegistryPostProcessor.getHasNativeAllocations();
        this.mySnapshot = snapshot;
        HashMap<Heap, HeapSet> heapSets = new HashMap<Heap, HeapSet>(snapshot.getHeaps().size());
        InstanceObject javaLangClassObject = null;
        for (Heap heap : snapshot.getHeaps()) {
            ClassObj javaLangClass;
            HeapSet heapSet2 = new HeapSet(this, heap.getName(), heap.getId());
            heapSets.put(heap, heapSet2);
            if (javaLangClassObject != null || (javaLangClass = (ClassObj)heap.getClasses().stream().filter(classObj -> "java.lang.Class".equals(classObj.getClassName())).findFirst().orElse(null)) == null) continue;
            javaLangClassObject = this.createClassObjectInstance(null, javaLangClass);
        }
        InstanceObject finalJavaLangClassObject = javaLangClassObject;
        for (Heap heap : snapshot.getHeaps()) {
            heapSet = (HeapSet)heapSets.get(heap);
            heap.getClasses().forEach(classObj -> {
                InstanceObject classObject = this.createClassObjectInstance(finalJavaLangClassObject, (ClassObj)classObj);
                assert (!this.myInstanceIndex.containsKey(classObj.getId()));
                this.myInstanceIndex.put(classObj.getId(), (Object)classObject);
                heapSet.addDeltaInstanceObject(classObject);
            });
        }
        for (Heap heap : snapshot.getHeaps()) {
            heapSet = (HeapSet)heapSets.get(heap);
            heap.forEachInstance(instance -> {
                assert (!"java.lang.Class".equals(instance.getClassObj().getClassName()));
                ClassObj classObj = instance.getClassObj();
                ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), classObj.getClassName()) : this.myClassDb.registerClass(classObj.getId(), classObj.getClassName());
                HeapDumpInstanceObject instanceObject = new HeapDumpInstanceObject(this, (Instance)instance, classEntry, null);
                assert (!this.myInstanceIndex.containsKey(instance.getId()));
                this.myInstanceIndex.put(instance.getId(), (Object)instanceObject);
                heapSet.addDeltaInstanceObject(instanceObject);
                return true;
            });
        }
        heapSets.forEach((key, value) -> {
            if ("default".equals(key.getName())) {
                if (heapSets.size() == 1 || key.getInstancesCount() > 0) {
                    this.myHeapSets.put(key.getId(), (HeapSet)value);
                }
            } else {
                this.myHeapSets.put(key.getId(), (HeapSet)value);
            }
        });
        this.myStage.refreshSelectedHeap();
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.mySnapshot != null || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
        this.myExecutorService.shutdownNow();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List<CaptureObject.ClassifierAttribute> list = this.myHasNativeAllocations ? Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.NATIVE_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE);
        if (list == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List<CaptureObject.InstanceAttribute> list = this.myHasNativeAllocations ? Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.NATIVE_SIZE, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE) : Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE);
        if (list == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public InstanceObject findInstanceObject(@NotNull Instance instance) {
        if (instance == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(13);
        }
        if (this.mySnapshot == null) {
            return null;
        }
        return (InstanceObject)this.myInstanceIndex.get(instance.getId());
    }

    @NotNull
    InstanceObject createClassObjectInstance(@Nullable InstanceObject javaLangClass, @NotNull ClassObj classObj) {
        if (classObj == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(14);
        }
        String className = javaLangClass == null ? "java.lang.Class" : classObj.getClassName();
        ClassDb.ClassEntry classEntry = classObj.getSuperClassObj() != null ? this.myClassDb.registerClass(classObj.getId(), classObj.getSuperClassObj().getId(), className) : this.myClassDb.registerClass(classObj.getId(), className);
        HeapDumpInstanceObject classObject = javaLangClass == null ? new HeapDumpInstanceObject(this, (Instance)classObj, classEntry, ValueObject.ValueType.CLASS) : new HeapDumpInstanceObject(this, (Instance)classObj, javaLangClass.getClassEntry(), ValueObject.ValueType.CLASS);
        HeapDumpInstanceObject heapDumpInstanceObject = classObject;
        if (heapDumpInstanceObject == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(15);
        }
        return heapDumpInstanceObject;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSupportedInstanceFilters() {
        Set<CaptureObjectInstanceFilter> set = this.mySupportedInstanceFilters;
        if (set == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(16);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSelectedInstanceFilters() {
        Set<CaptureObjectInstanceFilter> set = this.myCurrentInstanceFilters;
        if (set == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(17);
        }
        return set;
    }

    @VisibleForTesting
    ExecutorService getInstanceFilterExecutor() {
        return this.myExecutorService;
    }

    @Override
    public void addInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToAdd, @NotNull Executor analyzeJoiner) {
        if (filterToAdd == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(18);
        }
        if (analyzeJoiner == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(19);
        }
        assert (this.mySupportedInstanceFilters.contains(filterToAdd));
        this.myCurrentInstanceFilters.add(filterToAdd);
        this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING);
        this.myExecutorService.execute(() -> {
            HashSet<InstanceObject> currentMatchedInstances = new HashSet<InstanceObject>();
            for (HeapSet heap : this.myHeapSets.values()) {
                currentMatchedInstances.addAll(heap.getInstancesStream().collect(Collectors.toSet()));
            }
            Set<InstanceObject> matchedInstancesFinal = filterToAdd.filter(currentMatchedInstances, this.myClassDb);
            analyzeJoiner.execute(() -> {
                for (HeapSet heap : this.myHeapSets.values()) {
                    heap.clearClassifierSets();
                }
                matchedInstancesFinal.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addDeltaInstanceObject((InstanceObject)instance));
                this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED);
                this.myStage.refreshSelectedHeap();
            });
        });
    }

    @Override
    public void removeInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToRemove, @NotNull Executor analyzeJoiner) {
        if (filterToRemove == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(20);
        }
        if (analyzeJoiner == null) {
            HeapDumpCaptureObject.$$$reportNull$$$0(21);
        }
        if (!this.myCurrentInstanceFilters.contains(filterToRemove)) {
            return;
        }
        this.myCurrentInstanceFilters.remove(filterToRemove);
        this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING);
        this.myExecutorService.execute(() -> {
            HashSet<InstanceObject> allInstances = new HashSet<InstanceObject>(this.myInstanceIndex.size());
            this.myInstanceIndex.forEachValue(instance -> allInstances.add((InstanceObject)instance));
            Set<InstanceObject> matchedInstances = allInstances;
            for (CaptureObjectInstanceFilter filter : this.myCurrentInstanceFilters) {
                matchedInstances = filter.filter(matchedInstances, this.myClassDb);
            }
            HashSet<InstanceObject> matchedInstancesFinal = matchedInstances;
            analyzeJoiner.execute(() -> {
                for (HeapSet heap : this.myHeapSets.values()) {
                    heap.clearClassifierSets();
                }
                matchedInstancesFinal.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addDeltaInstanceObject((InstanceObject)instance));
                this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED);
                this.myStage.refreshSelectedHeap();
            });
        });
    }

    @Override
    public boolean canSafelyLoad() {
        Transport.BytesResponse response = this.myClient.getTransportClient().getBytes(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myHeapDumpInfo.getStartTime())).build());
        return MemoryProfilerStage.canSafelyLoadHprof(response.getSerializedSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapDumpInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapDumpCaptureObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classObj";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterToAdd";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzeJoiner";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapDumpCaptureObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDb";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassObjectInstance";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedInstanceFilters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedInstanceFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInstanceObject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createClassObjectInstance";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addInstanceFilter";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeInstanceFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

