/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.profilers.CloseButton;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.details.CallStackTabContent;
import com.android.tools.profilers.network.details.OverviewTabContent;
import com.android.tools.profilers.network.details.RequestTabContent;
import com.android.tools.profilers.network.details.ResponseTabContent;
import com.android.tools.profilers.network.details.TabContent;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionDetailsView
extends JPanel {
    @NotNull
    private final NetworkProfilerStageView myStageView;
    @NotNull
    private final CommonTabbedPane myTabsPanel;
    @NotNull
    private final List<TabContent> myTabs;

    public ConnectionDetailsView(@NotNull NetworkProfilerStageView stageView) {
        if (stageView == null) {
            ConnectionDetailsView.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myTabs = new ArrayList<TabContent>();
        this.myStageView = stageView;
        JPanel rootPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit-", "Fit-,*"));
        this.myTabsPanel = new CommonTabbedPane();
        this.myTabsPanel.setFont(ProfilerFonts.STANDARD_FONT);
        this.populateTabs();
        this.myTabsPanel.addChangeListener(e -> {
            this.repaint();
            this.trackActiveTab();
        });
        CloseButton closeButton = new CloseButton(e -> ((NetworkProfilerStage)this.myStageView.getStage()).setSelectedConnection(null));
        JPanel closeButtonWrapper = new JPanel(new BorderLayout());
        closeButtonWrapper.add((Component)((Object)closeButton), "Center");
        closeButtonWrapper.setBorder((Border)new JBEmptyBorder(3, 0, 0, 0));
        rootPanel.add((Component)closeButtonWrapper, new TabularLayout.Constraint(0, 1));
        rootPanel.add((Component)this.myTabsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        this.add(rootPanel);
    }

    private void populateTabs() {
        this.myTabs.add(new OverviewTabContent(((NetworkProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig(), this.myStageView.getIdeComponents(), ((NetworkProfilerStage)this.myStageView.getStage()).getConnectionsModel()));
        this.myTabs.add(new ResponseTabContent(this.myStageView.getIdeComponents(), ((NetworkProfilerStage)this.myStageView.getStage()).getConnectionsModel()));
        this.myTabs.add(new RequestTabContent(this.myStageView.getIdeComponents(), ((NetworkProfilerStage)this.myStageView.getStage()).getConnectionsModel()));
        this.myTabs.add(new CallStackTabContent(((NetworkProfilerStage)this.myStageView.getStage()).getConnectionsModel(), this.myStageView.getIdeComponents().createStackView(((NetworkProfilerStage)this.myStageView.getStage()).getStackTraceModel())));
        for (TabContent tab : this.myTabs) {
            this.myTabsPanel.addTab(tab.getTitle(), tab.getIcon(), (Component)tab.getComponent());
        }
    }

    private void trackActiveTab() {
        Optional<TabContent> selected = this.myTabs.stream().filter(t -> t.getComponent() == this.myTabsPanel.getSelectedComponent()).findFirst();
        if (selected.isPresent()) {
            FeatureTracker featureTracker = ((NetworkProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker();
            selected.get().trackWith(featureTracker);
        }
    }

    public void setHttpData(@Nullable HttpData httpData) {
        this.setBackground(JBColor.background());
        this.myTabs.forEach(tab -> tab.populateFor(httpData));
        this.setVisible(httpData != null);
        this.revalidate();
        this.repaint();
    }

    @NotNull
    @VisibleForTesting
    List<TabContent> getTabs() {
        List<TabContent> list = this.myTabs;
        if (list == null) {
            ConnectionDetailsView.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/ConnectionDetailsView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/ConnectionDetailsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

