/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApkDiffer {
    public List<FileDiff> diff(List<Apk> oldApks, List<Apk> newApks) throws DeployerException {
        ArrayList<ApkEntry> oldFiles = new ArrayList<ApkEntry>();
        HashMap<String, Map<String, ApkEntry>> oldMap = new HashMap<String, Map<String, ApkEntry>>();
        ApkDiffer.groupFiles(oldApks, oldFiles, oldMap);
        ArrayList<ApkEntry> newFiles = new ArrayList<ApkEntry>();
        HashMap<String, Map<String, ApkEntry>> newMap = new HashMap<String, Map<String, ApkEntry>>();
        ApkDiffer.groupFiles(newApks, newFiles, newMap);
        if (newMap.size() != oldMap.size()) {
            throw DeployerException.apkCountMismatch();
        }
        if (!newMap.keySet().equals(oldMap.keySet())) {
            throw DeployerException.apkNameMismatch();
        }
        ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
        for (ApkEntry newFile : newFiles) {
            ApkEntry oldFile = (ApkEntry)((Map)oldMap.get(newFile.getApk().name)).get(newFile.getName());
            if (oldFile == null) {
                diffs.add(new FileDiff(null, newFile, FileDiff.Status.CREATED));
                continue;
            }
            if (oldFile.getChecksum() == newFile.getChecksum()) continue;
            diffs.add(new FileDiff(oldFile, newFile, FileDiff.Status.MODIFIED));
        }
        for (ApkEntry oldFile : oldFiles) {
            ApkEntry newFile = (ApkEntry)((Map)newMap.get(oldFile.getApk().name)).get(oldFile.getName());
            if (newFile != null) continue;
            diffs.add(new FileDiff(oldFile, null, FileDiff.Status.DELETED));
        }
        return diffs;
    }

    private static void groupFiles(List<Apk> apks, List<ApkEntry> entries, Map<String, Map<String, ApkEntry>> map) {
        for (Apk apk : apks) {
            map.putIfAbsent(apk.name, apk.apkEntries);
            entries.addAll(apk.apkEntries.values());
        }
    }
}

