/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.PatchGenerator;
import com.android.tools.deployer.model.Apk;
import com.android.tools.idea.protobuf.ByteString;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchSetGenerator {
    public static final int MAX_PATCHSET_SIZE = 0x2800000;
    private ILogger logger;

    public PatchSetGenerator(ILogger logger) {
        this.logger = logger;
    }

    public List<Deploy.PatchInstruction> generateFromApks(List<Apk> localApks, List<Apk> remoteApks) {
        HashMap<String, Apk> localApkMap = new HashMap<String, Apk>();
        for (Apk apk : localApks) {
            localApkMap.put(apk.name, apk);
        }
        HashMap<String, Apk> remoteApkMap = new HashMap<String, Apk>();
        for (Apk apk : remoteApks) {
            remoteApkMap.put(apk.name, apk);
        }
        return this.generateFromApkSets(remoteApkMap, localApkMap);
    }

    public List<Deploy.PatchInstruction> generateFromApkSets(HashMap<String, Apk> remoteApks, HashMap<String, Apk> localApks) {
        try {
            if (remoteApks.size() != localApks.size()) {
                return null;
            }
            ArrayList<Pair<Apk, Apk>> pairs = new ArrayList<Pair<Apk, Apk>>();
            for (Map.Entry<String, Apk> localApk : localApks.entrySet()) {
                if (!remoteApks.keySet().contains(localApk.getValue().name)) {
                    return null;
                }
                pairs.add((Pair<Apk, Apk>)Pair.of((Object)localApk.getValue(), (Object)remoteApks.get(localApk.getValue().name)));
            }
            return this.generateFromPairs(pairs);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List<Deploy.PatchInstruction> generateFromPairs(List<Pair<Apk, Apk>> pairs) throws IOException {
        Apk remoteApk;
        Apk localApk;
        ArrayList<Deploy.PatchInstruction> patches = new ArrayList<Deploy.PatchInstruction>();
        boolean noChanges = true;
        for (Pair<Apk, Apk> pair : pairs) {
            localApk = (Apk)pair.getFirst();
            remoteApk = (Apk)pair.getSecond();
            if (remoteApk.checksum.equals(localApk.checksum)) continue;
            noChanges = false;
            break;
        }
        if (noChanges) {
            return patches;
        }
        for (Pair<Apk, Apk> pair : pairs) {
            localApk = (Apk)pair.getFirst();
            remoteApk = (Apk)pair.getSecond();
            Deploy.PatchInstruction instruction = null;
            instruction = localApk.checksum.equals(remoteApk.checksum) ? this.generateCleanPatch(remoteApk, localApk) : this.generateDelta(remoteApk, localApk);
            patches.add(instruction);
        }
        assert (pairs.size() == patches.size());
        return patches;
    }

    private Deploy.PatchInstruction generateDelta(Apk remoteApk, Apk localApk) throws IOException {
        PatchGenerator.Patch patch = new PatchGenerator(this.logger).generate(remoteApk, localApk);
        return this.buildPatchInstruction(patch.destinationSize, patch.sourcePath, patch.instructions, patch.data);
    }

    private Deploy.PatchInstruction buildPatchInstruction(long size, String remotePath, ByteBuffer instruction, ByteBuffer data) {
        Deploy.PatchInstruction.Builder patchInstructionBuidler = Deploy.PatchInstruction.newBuilder();
        patchInstructionBuidler.setSrcAbsolutePath(remotePath);
        patchInstructionBuidler.setPatches(ByteString.copyFrom((ByteBuffer)data));
        patchInstructionBuidler.setInstructions(ByteString.copyFrom((ByteBuffer)instruction));
        patchInstructionBuidler.setDstFilesize(size);
        Deploy.PatchInstruction patch = (Deploy.PatchInstruction)patchInstructionBuidler.build();
        return patch;
    }

    private Deploy.PatchInstruction generateCleanPatch(Apk remoteApk, Apk localApk) throws IOException {
        Deploy.PatchInstruction.Builder patchInstructionBuidler = Deploy.PatchInstruction.newBuilder();
        PatchGenerator.Patch patch = new PatchGenerator(this.logger).generateCleanPatch(remoteApk, localApk);
        patchInstructionBuidler.setSrcAbsolutePath(patch.sourcePath);
        patchInstructionBuidler.setDstFilesize(patch.destinationSize);
        return (Deploy.PatchInstruction)patchInstructionBuidler.build();
    }
}

