/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@ApiStatus.Experimental
public interface TargetEnvironmentAwareRunProfileState
extends RunProfileState {
    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest var1, @Nullable TargetEnvironmentConfiguration var2, @NotNull TargetProgressIndicator var3) throws ExecutionException;

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment var1, @NotNull TargetProgressIndicator var2) throws ExecutionException;

    default public <T> Promise<T> prepareTargetToCommandExecution(@NotNull ExecutionEnvironment env, @NotNull Logger logger, @NonNls String logFailureMessage, @NotNull ThrowableComputable<? extends T, ? extends Throwable> computationForAWT) throws ExecutionException {
        if (env == null) {
            TargetEnvironmentAwareRunProfileState.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            TargetEnvironmentAwareRunProfileState.$$$reportNull$$$0(1);
        }
        if (computationForAWT == null) {
            TargetEnvironmentAwareRunProfileState.$$$reportNull$$$0(2);
        }
        ExecutionManager executionManager = ExecutionManager.getInstance(env.getProject());
        return executionManager.executePreparationTasks(env, this).thenAsync(o -> {
            AsyncPromise promise = new AsyncPromise();
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    promise.setResult(computationForAWT.compute());
                }
                catch (ProcessCanceledException e) {
                    promise.setError(e.getLocalizedMessage());
                }
                catch (Throwable t) {
                    logger.warn(logFailureMessage, t);
                    promise.setError(t.getLocalizedMessage());
                }
            });
            return promise;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "computationForAWT";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/target/TargetEnvironmentAwareRunProfileState";
        objectArray[2] = "prepareTargetToCommandExecution";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TargetProgressIndicator {
        public static final TargetProgressIndicator EMPTY = new TargetProgressIndicator(){

            @Override
            public void addText(@NotNull String text, @NotNull Key<?> key) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (key == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void stop() {
            }

            @Override
            public boolean isStopped() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/target/TargetEnvironmentAwareRunProfileState$TargetProgressIndicator$1";
                objectArray[2] = "addText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        public void addText(@NotNull String var1, @NotNull Key<?> var2);

        default public void addSystemLine(@NotNull String message) {
            if (message == null) {
                TargetProgressIndicator.$$$reportNull$$$0(0);
            }
            this.addText(message + "\n", (Key<?>)ProcessOutputType.SYSTEM);
        }

        public boolean isCanceled();

        public void stop();

        public boolean isStopped();

        default public void stopWithErrorMessage(@NotNull String text) {
            if (text == null) {
                TargetProgressIndicator.$$$reportNull$$$0(1);
            }
            this.addText(text, (Key<?>)ProcessOutputType.STDERR);
            this.addText("\n", (Key<?>)ProcessOutputType.STDERR);
            this.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/target/TargetEnvironmentAwareRunProfileState$TargetProgressIndicator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addSystemLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopWithErrorMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

