/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.local;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LocalTargetEnvironment
extends TargetEnvironment {
    private final Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> myUploadVolumes;
    private final Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> myDownloadVolumes;
    private final Map<TargetEnvironment.TargetPortBinding, Integer> myTargetPortBindings;
    private final Map<TargetEnvironment.LocalPortBinding, HostPort> myLocalPortBindings;

    public LocalTargetEnvironment(@NotNull TargetEnvironmentRequest request) {
        if (request == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(0);
        }
        super(request);
        this.myUploadVolumes = new HashMap<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume>();
        this.myDownloadVolumes = new HashMap<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume>();
        this.myTargetPortBindings = new HashMap<TargetEnvironment.TargetPortBinding, Integer>();
        this.myLocalPortBindings = new HashMap<TargetEnvironment.LocalPortBinding, HostPort>();
        for (TargetEnvironment.UploadRoot uploadRoot : request.getUploadVolumes()) {
            Path targetRoot = uploadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent ? Paths.get(((TargetEnvironment.TargetPath.Persistent)uploadRoot.getTargetRootPath()).getAbsolutePath(), new String[0]) : uploadRoot.getLocalRootPath().toAbsolutePath();
            this.myUploadVolumes.put(uploadRoot, new LocalVolume(uploadRoot.getLocalRootPath(), targetRoot));
        }
        for (TargetEnvironment.DownloadRoot downloadRoot : request.getDownloadVolumes()) {
            Path localRoot;
            if (downloadRoot.getLocalRootPath() != null) {
                localRoot = downloadRoot.getLocalRootPath();
            } else {
                try {
                    localRoot = FileUtil.createTempDirectory((String)"intellij-target", (String)"", (boolean)true).toPath();
                }
                catch (IOException err) {
                    throw new IllegalStateException(err);
                }
            }
            Path targetRoot = downloadRoot.getTargetRootPath() instanceof TargetEnvironment.TargetPath.Persistent ? Paths.get(((TargetEnvironment.TargetPath.Persistent)downloadRoot.getTargetRootPath()).getAbsolutePath(), new String[0]) : localRoot;
            this.myDownloadVolumes.put(downloadRoot, new LocalVolume(localRoot, targetRoot));
        }
        for (TargetEnvironment.TargetPortBinding targetPortBinding : request.getTargetPortBindings()) {
            int theOnlyPort = targetPortBinding.getTarget();
            if (targetPortBinding.getLocal() != null && !targetPortBinding.getLocal().equals(theOnlyPort)) {
                throw new UnsupportedOperationException("Local target's TCP port forwarder is not implemented");
            }
            this.myTargetPortBindings.put(targetPortBinding, theOnlyPort);
        }
        for (TargetEnvironment.LocalPortBinding localPortBinding : request.getLocalPortBindings()) {
            int theOnlyPort = localPortBinding.getLocal();
            if (localPortBinding.getTarget() != null && !localPortBinding.getTarget().equals(theOnlyPort)) {
                throw new UnsupportedOperationException("Local target's TCP port forwarder is not implemented");
            }
            this.myLocalPortBindings.put(localPortBinding, new HostPort("localhost", theOnlyPort));
        }
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> getUploadVolumes() {
        Map<TargetEnvironment.UploadRoot, TargetEnvironment.UploadableVolume> map = Collections.unmodifiableMap(this.myUploadVolumes);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> getDownloadVolumes() {
        Map<TargetEnvironment.DownloadRoot, TargetEnvironment.DownloadableVolume> map = Collections.unmodifiableMap(this.myDownloadVolumes);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.TargetPortBinding, Integer> getTargetPortBindings() {
        Map<TargetEnvironment.TargetPortBinding, Integer> map = Collections.unmodifiableMap(this.myTargetPortBindings);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<TargetEnvironment.LocalPortBinding, HostPort> getLocalPortBindings() {
        Map<TargetEnvironment.LocalPortBinding, HostPort> map = Collections.unmodifiableMap(this.myLocalPortBindings);
        if (map == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = TargetPlatform.CURRENT;
        if (targetPlatform == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(5);
        }
        return targetPlatform;
    }

    @Override
    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (commandLine == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(7);
        }
        Process process = this.createGeneralCommandLine(commandLine).createProcess();
        if (process == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(8);
        }
        return process;
    }

    @NotNull
    public GeneralCommandLine createGeneralCommandLine(@NotNull TargetedCommandLine commandLine) throws CantRunException {
        GeneralCommandLine generalCommandLine;
        if (commandLine == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(9);
        }
        try {
            String inputFilePath;
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(commandLine.collectCommandsSynchronously());
            if (this.getRequest() instanceof LocalTargetEnvironmentRequest) {
                generalCommandLine2.withParentEnvironmentType(((LocalTargetEnvironmentRequest)this.getRequest()).getParentEnvironmentType());
            }
            if ((inputFilePath = commandLine.getInputFilePath()) != null) {
                generalCommandLine2.withInput(new File(inputFilePath));
            }
            generalCommandLine2.withCharset(commandLine.getCharset());
            String workingDirectory = commandLine.getWorkingDirectory();
            if (workingDirectory != null) {
                generalCommandLine2.withWorkDirectory(workingDirectory);
            }
            generalCommandLine2.withEnvironment(commandLine.getEnvironmentVariables());
            generalCommandLine = generalCommandLine2;
        }
        catch (ExecutionException e) {
            throw new CantRunException(e.getMessage(), e);
        }
        if (generalCommandLine == null) {
            LocalTargetEnvironment.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    @Override
    public void shutdown() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironment";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUploadVolumes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadVolumes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPortBindings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPortBindings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneralCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGeneralCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LocalVolume
    implements TargetEnvironment.UploadableVolume,
    TargetEnvironment.DownloadableVolume {
        private final Path myLocalRoot;
        private final Path myTargetRoot;
        private final boolean myReal;

        private LocalVolume(@NotNull Path localRoot, @NotNull Path targetRoot) {
            boolean real;
            if (localRoot == null) {
                LocalVolume.$$$reportNull$$$0(0);
            }
            if (targetRoot == null) {
                LocalVolume.$$$reportNull$$$0(1);
            }
            this.myLocalRoot = localRoot;
            this.myTargetRoot = targetRoot;
            try {
                real = Files.exists(localRoot, new LinkOption[0]) && !this.myLocalRoot.toRealPath(LinkOption.NOFOLLOW_LINKS).equals(this.myTargetRoot.toRealPath(LinkOption.NOFOLLOW_LINKS));
            }
            catch (IOException e) {
                real = true;
            }
            this.myReal = real;
        }

        @Override
        @NotNull
        public Path getLocalRoot() {
            Path path2 = this.myLocalRoot;
            if (path2 == null) {
                LocalVolume.$$$reportNull$$$0(2);
            }
            return path2;
        }

        @Override
        @NotNull
        public String getTargetRoot() {
            String string = this.myTargetRoot.toString();
            if (string == null) {
                LocalVolume.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String resolveTargetPath(@NotNull String relativePath) throws IOException {
            if (relativePath == null) {
                LocalVolume.$$$reportNull$$$0(4);
            }
            if (this.myReal) {
                File targetFile = this.myTargetRoot.resolve(relativePath).toFile().getCanonicalFile();
                String string = targetFile.toString();
                if (string == null) {
                    LocalVolume.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{this.myLocalRoot.toString(), relativePath})).replace('/', File.separatorChar);
            if (string == null) {
                LocalVolume.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public void upload(@NotNull String relativePath, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) throws IOException {
            if (relativePath == null) {
                LocalVolume.$$$reportNull$$$0(7);
            }
            if (targetProgressIndicator == null) {
                LocalVolume.$$$reportNull$$$0(8);
            }
            if (this.myReal) {
                File targetFile = this.myTargetRoot.resolve(relativePath).toFile().getCanonicalFile();
                FileUtil.copyFileOrDir((File)this.myLocalRoot.resolve(relativePath).toFile().getCanonicalFile(), (File)targetFile);
            }
        }

        @Override
        public void download(@NotNull String relativePath, @NotNull ProgressIndicator progressIndicator) throws IOException {
            if (relativePath == null) {
                LocalVolume.$$$reportNull$$$0(9);
            }
            if (progressIndicator == null) {
                LocalVolume.$$$reportNull$$$0(10);
            }
            if (this.myReal) {
                FileUtil.copyFileOrDir((File)this.myTargetRoot.resolve(relativePath).toFile().getCanonicalFile(), (File)this.myLocalRoot.resolve(relativePath).toFile().getCanonicalFile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRoot";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironment$LocalVolume";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetProgressIndicator";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironment$LocalVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalRoot";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetRoot";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveTargetPath";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "upload";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "download";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

