/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;

public abstract class RemoteDesktopService {
    private static volatile RemoteDesktopService ourInstance;

    public static RemoteDesktopService getInstance() {
        RemoteDesktopService service = ourInstance;
        if (service == null) {
            ourInstance = service = (RemoteDesktopService)ApplicationManager.getApplication().getService(RemoteDesktopService.class);
        }
        return service;
    }

    public static boolean isRemoteSession() {
        if (!SystemInfo.isWindows) {
            return false;
        }
        if (ApplicationManager.getApplication() == null) {
            return false;
        }
        RemoteDesktopService instance = RemoteDesktopService.getInstance();
        return instance != null && instance.isRemoteDesktopConnected();
    }

    public abstract boolean isRemoteDesktopConnected();
}

