/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.UntrustedProjectModeProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001e\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleUntrustedModeProvider;", "Lcom/intellij/openapi/externalSystem/service/project/UntrustedProjectModeProvider;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/NonNls;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "loadAllLinkedProjects", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldShowEditorNotification", "", "intellij.gradle.common"})
public final class GradleUntrustedModeProvider
implements UntrustedProjectModeProvider {
    @NotNull
    private final ProjectSystemId systemId;

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean shouldShowEditorNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        Collection collection = settings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"settings.linkedProjectsSettings");
        Collection collection2 = collection;
        boolean bl = false;
        return !collection2.isEmpty();
    }

    public void loadAllLinkedProjects(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        Iterator iterator = settings2.getLinkedProjectsSettings().iterator();
        while (iterator.hasNext()) {
            GradleProjectSettings linkedProjectSettings;
            GradleProjectSettings gradleProjectSettings = linkedProjectSettings = (GradleProjectSettings)((Object)iterator.next());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleProjectSettings), (String)"linkedProjectSettings");
            String externalProjectPath = gradleProjectSettings.getExternalProjectPath();
            ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)new ImportSpecBuilder(project, this.getSystemId()));
        }
    }

    public GradleUntrustedModeProvider() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
        this.systemId = projectSystemId;
    }
}

