/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.ModuleTaskData;
import org.jetbrains.plugins.gradle.util.ProjectTaskData;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u001a.\u0010\n\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\f0\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a(\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\f0\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0002\u00a8\u0006\u0013"}, d2={"findGradleTasks", "", "Lorg/jetbrains/plugins/gradle/util/ProjectTaskData;", "project", "Lcom/intellij/openapi/project/Project;", "getGradleFqnTaskName", "", "gradleModulePath", "taskData", "Lcom/intellij/openapi/externalSystem/model/task/TaskData;", "getGradleTaskNodesMap", "", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "getGradleTasksMap", "getModuleTasks", "Lorg/jetbrains/plugins/gradle/util/ModuleTaskData;", "moduleNode", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "intellij.gradle.common"})
public final class GradleTasksUtilKt {
    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @NotNull
    public static final Map<String, MultiMap<String, TaskData>> getGradleTasksMap(@NotNull Project project) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map<String, MultiMap<String, DataNode<TaskData>>> $this$mapValues$iv = GradleTasksUtilKt.getGradleTaskNodesMap(project);
        boolean $i$f$mapValues = false;
        Map<String, MultiMap<String, DataNode<TaskData>>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            MultiMap transformed;
            void $dstr$_u24__u24$moduleTasks;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            void var16_16 = $dstr$_u24__u24$moduleTasks;
            boolean bl3 = false;
            MultiMap moduleTasks = (MultiMap)var16_16.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)MultiMap.create(), (String)"MultiMap.create<String, TaskData>()");
            for (Map.Entry entry3 : moduleTasks.entrySet()) {
                Collection<TaskData> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void gradleModulePath;
                Collection moduleTaskNodes;
                Object object = entry3;
                boolean bl4 = false;
                String string = (String)object.getKey();
                object = entry3;
                bl4 = false;
                Collection collection2 = moduleTaskNodes = (Collection)object.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"moduleTaskNodes");
                object = collection2;
                void var24_25 = gradleModulePath;
                MultiMap multiMap = transformed;
                boolean $i$f$map = false;
                void var26_27 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DataNode dataNode = (DataNode)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    TaskData taskData = (TaskData)v1.getData();
                    collection.add(taskData);
                }
                collection = (List)destination$iv$iv2;
                multiMap.putValues((Object)var24_25, (Collection)collection);
            }
            MultiMap multiMap = transformed;
            map3.put(k2, multiMap);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @NotNull
    public static final Map<String, MultiMap<String, DataNode<TaskData>>> getGradleTaskNodesMap(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LinkedHashMap tasks = new LinkedHashMap();
        for (ProjectTaskData projectTaskData : GradleTasksUtilKt.findGradleTasks(project)) {
            MultiMap projectTasks;
            Intrinsics.checkNotNullExpressionValue((Object)MultiMap.createOrderedSet(), (String)"MultiMap.createOrderedSe\u2026ng, DataNode<TaskData>>()");
            PathPrefixTreeMap modulePaths = new PathPrefixTreeMap(":", false);
            for (ModuleTaskData moduleTaskData : projectTaskData.getModulesTaskData()) {
                modulePaths.set(moduleTaskData.getGradlePath(), (Object)moduleTaskData.getExternalModulePath());
                projectTasks.putValues((Object)moduleTaskData.getGradlePath(), (Collection)moduleTaskData.getTasks());
            }
            Object object = (Map)modulePaths;
            boolean bl = false;
            Iterator<Object> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                MultiMap moduleTasks;
                void gradlePath;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl2 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                String externalModulePath = (String)entry2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)MultiMap.createOrderedSet(), (String)"MultiMap.createOrderedSe\u2026ng, DataNode<TaskData>>()");
                Set childrenModulesPaths = modulePaths.getAllDescendantKeys((String)gradlePath);
                for (String childModulePath : childrenModulesPaths) {
                    moduleTasks.putValues((Object)childModulePath, projectTasks.get((Object)childModulePath));
                }
                ((Map)tasks).put(externalModulePath, moduleTasks);
            }
        }
        return tasks;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String getGradleFqnTaskName(@NotNull String gradleModulePath, @NotNull TaskData taskData) {
        Intrinsics.checkNotNullParameter((Object)gradleModulePath, (String)"gradleModulePath");
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        String taskPath = StringsKt.removeSuffix((String)gradleModulePath, (CharSequence)":");
        String string = taskData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskData.name");
        String taskName = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)gradleModulePath), (CharSequence)":");
        return taskPath + ':' + taskName;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ProjectTaskData> findGradleTasks(Project project) {
        Object projectNode;
        Object destination$iv$iv;
        Object compositeParticipants;
        ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
        MultiMap multiMap = MultiMap.createOrderedSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.createOrderedSe\u2026, DataNode<ModuleData>>()");
        MultiMap projects2 = multiMap;
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        Object object = gradleSettings.getLinkedProjectsSettings().iterator();
        while (object.hasNext()) {
            Collection moduleNodes;
            void $this$flatMapTo$iv$iv;
            GradleProjectSettings settings2;
            GradleProjectSettings gradleProjectSettings = settings2 = (GradleProjectSettings)((Object)object.next());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleProjectSettings), (String)"settings");
            ExternalProjectInfo projectInfo = projectDataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, gradleProjectSettings.getExternalProjectPath());
            Object object2 = settings2.getCompositeBuild();
            if (object2 == null || (object2 = ((GradleProjectSettings.CompositeBuild)object2).getCompositeParticipants()) == null) {
                object2 = CollectionsKt.emptyList();
            }
            compositeParticipants = object2;
            Iterable $this$flatMap$iv = (Iterable)compositeParticipants;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                BuildParticipant it = (BuildParticipant)element$iv$iv;
                boolean bl = false;
                BuildParticipant buildParticipant = it;
                Intrinsics.checkNotNullExpressionValue((Object)buildParticipant, (String)"it");
                Set<String> set = buildParticipant.getProjects();
                Intrinsics.checkNotNullExpressionValue(set, (String)"it.projects");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void module;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair pair = TuplesKt.to((Object)module, (Object)it.getRootPath());
                    collection.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map compositeProjects = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            ExternalProjectInfo externalProjectInfo = projectInfo;
            if (externalProjectInfo == null || (externalProjectInfo = externalProjectInfo.getExternalProjectStructure()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"projectInfo?.externalProjectStructure ?: continue");
            projectNode = externalProjectInfo;
            Intrinsics.checkNotNullExpressionValue((Object)ExternalSystemApiUtil.getChildren((DataNode)projectNode, (Key)ProjectKeys.MODULE), (String)"ExternalSystemApiUtil.ge\u2026Node, ProjectKeys.MODULE)");
            destination$iv$iv = moduleNodes.iterator();
            while (destination$iv$iv.hasNext()) {
                String externalModulePath;
                DataNode moduleNode;
                DataNode dataNode = moduleNode = (DataNode)destination$iv$iv.next();
                Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"moduleNode");
                Object object3 = dataNode.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"moduleNode.data");
                Intrinsics.checkNotNullExpressionValue((Object)((ModuleData)object3).getLinkedExternalProjectPath(), (String)"moduleNode.data.linkedExternalProjectPath");
                String string = (String)compositeProjects.get(externalModulePath);
                if (string == null) {
                    string = settings2.getExternalProjectPath();
                }
                String projectPath = string;
                projects2.putValue((Object)projectPath, (Object)moduleNode);
            }
        }
        ArrayList<ProjectTaskData> projectTasksData = new ArrayList<ProjectTaskData>();
        Iterator iterator = projects2.entrySet().iterator();
        while (iterator.hasNext()) {
            void externalProjectPath;
            void $this$mapTo$iv$iv;
            Collection modulesNodes;
            projectNode = object = (Map.Entry)iterator.next();
            boolean moduleNodes = false;
            compositeParticipants = (String)projectNode.getKey();
            projectNode = object;
            moduleNodes = false;
            Collection collection = modulesNodes = (Collection)projectNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"modulesNodes");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                DataNode bl = (DataNode)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl3 = false;
                ModuleTaskData moduleTaskData = GradleTasksUtilKt.getModuleTasks((DataNode<ModuleData>)p1);
                collection2.add(moduleTaskData);
            }
            List modulesTaskData = (List)destination$iv$iv3;
            void v11 = externalProjectPath;
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"externalProjectPath");
            projectTasksData.add(new ProjectTaskData((String)v11, modulesTaskData));
        }
        return projectTasksData;
    }

    /*
     * WARNING - void declaration
     */
    private static final ModuleTaskData getModuleTasks(DataNode<ModuleData> moduleNode) {
        void $this$filterTo$iv$iv;
        Object object = moduleNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"moduleNode.data");
        ModuleData moduleData = (ModuleData)object;
        String string = moduleData.getLinkedExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleData.linkedExternalProjectPath");
        String externalModulePath = string;
        String string2 = GradleProjectResolverUtil.getGradlePath(moduleData);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleProjectResolverUti\u2026getGradlePath(moduleData)");
        String gradlePath = StringsKt.removeSuffix((String)string2, (CharSequence)":");
        Collection collection = ExternalSystemApiUtil.getChildren(moduleNode, (Key)ProjectKeys.TASK);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026leNode, ProjectKeys.TASK)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataNode it = (DataNode)element$iv$iv;
            boolean bl = false;
            DataNode dataNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"it");
            Object object2 = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.data");
            String string3 = ((TaskData)object2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.data.name");
            CharSequence charSequence = string3;
            boolean bl2 = false;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasks = (List)destination$iv$iv;
        return new ModuleTaskData(externalModulePath, gradlePath, tasks);
    }
}

