/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.features.FilePredictionFeaturesCache;
import com.intellij.filePrediction.features.FilePredictionSimilarityFeatures;
import com.intellij.filePrediction.features.FilePredictionSimilarityFeatures$sam$com_intellij_util_Function$0;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\n\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\"\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n`\u000bH\u0002JN\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00062\"\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n`\u000bH\u0002J6\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\u001a\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/filePrediction/features/FilePredictionSimilarityFeatures;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "()V", "addNameSimilarity", "", "newFileName", "", "prevFileName", "result", "Ljava/util/HashMap;", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "Lkotlin/collections/HashMap;", "addPathSimilarity", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "root", "prefix", "calculateFileFeatures", "", "project", "Lcom/intellij/openapi/project/Project;", "cache", "Lcom/intellij/filePrediction/features/FilePredictionFeaturesCache;", "findCommonAncestor", "", "newDirs", "", "prevDirs", "getFeatures", "getName", "getRelativePath", "file", "ancestor", "unify", "path", "Companion", "intellij.filePrediction"})
public final class FilePredictionSimilarityFeatures
implements FilePredictionFeatureProvider {
    private static final ArrayList<String> FEATURES;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getName() {
        return "similarity";
    }

    @Override
    @NotNull
    public List<String> getFeatures() {
        return FEATURES;
    }

    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull FilePredictionFeaturesCache cache) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        HashMap<String, FilePredictionFeature> result2 = new HashMap<String, FilePredictionFeature>();
        ApplicationManager.getApplication().runReadAction(new Runnable(newFile, project, result2, prevFile){
            final /* synthetic */ VirtualFile $newFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap $result;
            final /* synthetic */ VirtualFile $prevFile;

            public final void run() {
                if (this.$newFile.isValid()) {
                    FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.$project);
                    ((Map)this.$result).put("in_project", FilePredictionFeature.Companion.binary(fileIndex.isInProjectScope(this.$newFile)));
                    ((Map)this.$result).put("in_source", FilePredictionFeature.Companion.binary(fileIndex.isInSource(this.$newFile)));
                    ((Map)this.$result).put("in_library", FilePredictionFeature.Companion.binary(fileIndex.isInLibraryClasses(this.$newFile) || fileIndex.isInLibrarySource(this.$newFile)));
                    ((Map)this.$result).put("excluded", FilePredictionFeature.Companion.binary(fileIndex.isExcludedFile(this.$newFile)));
                    if (this.$prevFile != null && this.$prevFile.isValid()) {
                        Module newModule = fileIndex.getModuleForFile(this.$newFile);
                        ((Map)this.$result).put("same_module", FilePredictionFeature.Companion.binary(newModule != null && Intrinsics.areEqual((Object)newModule, (Object)fileIndex.getModuleForFile(this.$prevFile))));
                    }
                    ((Map)this.$result).put("light", FilePredictionFeature.Companion.binary(this.$newFile instanceof LightVirtualFile));
                }
            }
            {
                this.$newFile = virtualFile;
                this.$project = project;
                this.$result = hashMap;
                this.$prevFile = virtualFile2;
            }
        });
        if (prevFile != null) {
            VirtualFile baseDir;
            String string = FileUtil.getNameWithoutExtension((String)newFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.getNameWithoutExtension(newFile.name)");
            String newFileName = string;
            String string2 = FileUtil.getNameWithoutExtension((String)prevFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.getNameWithoutExtension(prevFile.name)");
            String prevFileName = string2;
            this.addNameSimilarity(newFileName, prevFileName, result2);
            this.addPathSimilarity(newFile, prevFile, null, "", result2);
            if (!project.isDisposed() && (baseDir = ProjectUtil.guessProjectDir((Project)project)) != null && VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)newFile, (boolean)false) && VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)prevFile, (boolean)false)) {
                this.addPathSimilarity(newFile, prevFile, baseDir, "relative_", result2);
            }
            VirtualFile newDir = newFile.getParent();
            VirtualFile prevDir = prevFile.getParent();
            Map map = result2;
            VirtualFile virtualFile = newDir;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"newDir");
            String string3 = virtualFile.getPath();
            VirtualFile virtualFile2 = prevDir;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"prevDir");
            map.put("same_dir", FilePredictionFeature.Companion.binary(FileUtil.pathsEqual((String)string3, (String)virtualFile2.getPath())));
            boolean isAncestor = FileUtil.isAncestor((String)newDir.getPath(), (String)prevDir.getPath(), (boolean)false) || FileUtil.isAncestor((String)prevDir.getPath(), (String)newDir.getPath(), (boolean)false);
            ((Map)result2).put("ancestor", FilePredictionFeature.Companion.binary(isAncestor));
        }
        return result2;
    }

    private final void addPathSimilarity(VirtualFile newFile, VirtualFile prevFile, VirtualFile root, String prefix, HashMap<String, FilePredictionFeature> result2) {
        String newPath = this.getRelativePath(newFile, root);
        String prevPath = this.getRelativePath(prevFile, root);
        int commonPrefixLen = StringUtil.commonPrefixLength((CharSequence)newPath, (CharSequence)prevPath);
        ((Map)result2).put(prefix + "path_prefix", FilePredictionFeature.Companion.numerical(commonPrefixLen));
        ((Map)result2).put(prefix + "path_prefix_norm", FilePredictionFeature.Companion.numerical((double)2 * (double)commonPrefixLen / (double)(newPath.length() + prevPath.length())));
        List list = FileUtil.splitPath((String)newPath, (char)'/');
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"FileUtil.splitPath(newPath, '/')");
        List newDirs = list;
        List list2 = FileUtil.splitPath((String)prevPath, (char)'/');
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"FileUtil.splitPath(prevPath, '/')");
        List prevDirs = list2;
        int common = this.findCommonAncestor(newDirs, prevDirs);
        int maxDistance = newDirs.size() + prevDirs.size() - 2;
        ((Map)result2).put(prefix + "common", FilePredictionFeature.Companion.numerical(common));
        ((Map)result2).put(prefix + "common_norm", FilePredictionFeature.Companion.numerical(maxDistance != 0 ? (double)2 * (double)common / (double)maxDistance : 0.0));
        int distance = maxDistance - 2 * common;
        ((Map)result2).put(prefix + "distance", FilePredictionFeature.Companion.numerical(distance));
        ((Map)result2).put(prefix + "distance_norm", FilePredictionFeature.Companion.numerical(maxDistance != 0 ? (double)distance / (double)maxDistance : 0.0));
    }

    private final int findCommonAncestor(List<String> newDirs, List<String> prevDirs) {
        int i;
        for (i = 0; i < newDirs.size() - 1 && i < prevDirs.size() - 1 && FileUtil.namesEqual((String)newDirs.get(i), (String)prevDirs.get(i)); ++i) {
        }
        return i;
    }

    private final String getRelativePath(VirtualFile file, VirtualFile ancestor) {
        String relative;
        if (ancestor != null && (relative = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)ancestor)) != null) {
            return this.unify(relative);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return this.unify(string);
    }

    private final void addNameSimilarity(String newFileName, String prevFileName, HashMap<String, FilePredictionFeature> result2) {
        int commonPrefixLen = StringUtil.commonPrefixLength((CharSequence)newFileName, (CharSequence)prevFileName);
        ((Map)result2).put("name_prefix", FilePredictionFeature.Companion.numerical(commonPrefixLen));
        ((Map)result2).put("name_prefix_norm", FilePredictionFeature.Companion.numerical((double)2 * (double)commonPrefixLen / (double)(newFileName.length() + prevFileName.length())));
        int common = 0;
        Object[] objectArray = NameUtilCore.nameToWords((String)newFileName);
        Object object = addNameSimilarity.newWords.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new FilePredictionSimilarityFeatures$sam$com_intellij_util_Function$0(function1);
        }
        Set set = ContainerUtil.map2Set((Object[])objectArray, (Function)((Function)object));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ContainerUtil.map2Set(Na\u2026e), Strings::toLowerCase)");
        Set newWords2 = set;
        Object[] objectArray2 = NameUtilCore.nameToWords((String)prevFileName);
        Object object2 = addNameSimilarity.prevWords.1.INSTANCE;
        if (object2 != null) {
            Function1 function1 = object2;
            object2 = new FilePredictionSimilarityFeatures$sam$com_intellij_util_Function$0(function1);
        }
        Set set2 = ContainerUtil.map2Set((Object[])objectArray2, (Function)((Function)object2));
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"ContainerUtil.map2Set(Na\u2026e), Strings::toLowerCase)");
        Set prevWords2 = set2;
        for (String prevWord : prevWords2) {
            if (!newWords2.contains(prevWord)) continue;
            ++common;
        }
        ((Map)result2).put("common_words", FilePredictionFeature.Companion.numerical(common));
        ((Map)result2).put("common_words_norm", FilePredictionFeature.Companion.numerical((double)2 * (double)common / (double)(newWords2.size() + prevWords2.size())));
    }

    private final String unify(String path) {
        String string;
        boolean caseSensitive = SystemInfo.isFileSystemCaseSensitive;
        if (caseSensitive) {
            String string2 = FileUtil.getNameWithoutExtension((String)path);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.getNameWithoutExtension(path)");
        } else {
            String string3 = FileUtil.getNameWithoutExtension((String)StringUtil.toLowerCase((String)path));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.getNameWithoutE\u2026ension(toLowerCase(path))");
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        FEATURES = CollectionsKt.arrayListOf((Object[])new String[]{"ancestor", "common", "common_norm", "common_words", "common_words_norm", "distance", "distance_norm", "excluded", "in_library", "in_project", "in_source", "light", "name_prefix", "name_prefix_norm", "path_prefix", "path_prefix_norm", "relative_common", "relative_common_norm", "relative_distance", "relative_distance_norm", "relative_path_prefix", "relative_path_prefix_norm", "same_dir", "same_module"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/FilePredictionSimilarityFeatures$Companion;", "", "()V", "FEATURES", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "intellij.filePrediction"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

