/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FileHistoryFeatures;
import com.intellij.filePrediction.features.history.FileHistoryPersistence;
import com.intellij.filePrediction.features.history.FilePredictionHistoryState;
import com.intellij.filePrediction.features.history.FileSequenceModelHelper;
import com.intellij.filePrediction.features.history.NextFileProbability;
import com.intellij.filePrediction.features.history.RecentFileEntry;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0007J\u0017\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0005J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManager;", "", "state", "Lcom/intellij/filePrediction/features/history/FilePredictionHistoryState;", "recentFilesLimit", "", "(Lcom/intellij/filePrediction/features/history/FilePredictionHistoryState;I)V", "helper", "Lcom/intellij/filePrediction/features/history/FileSequenceModelHelper;", "getHelper", "()Lcom/intellij/filePrediction/features/history/FileSequenceModelHelper;", "calcHistoryFeatures", "Lcom/intellij/filePrediction/features/history/FileHistoryFeatures;", "fileUrl", "", "cleanup", "", "findEntry", "findOrAddEntry", "Lcom/intellij/filePrediction/features/history/RecentFileEntry;", "limit", "getState", "nextCode", "removed", "(Ljava/lang/Integer;)I", "onFileOpened", "saveFileHistory", "project", "Lcom/intellij/openapi/project/Project;", "size", "trimRecentFilesSize", "(I)Ljava/lang/Integer;", "intellij.filePrediction"})
public final class FileHistoryManager {
    @NotNull
    private final FileSequenceModelHelper helper;
    private FilePredictionHistoryState state;
    private final int recentFilesLimit;

    @NotNull
    public final FileSequenceModelHelper getHelper() {
        return this.helper;
    }

    @TestOnly
    @NotNull
    public final synchronized FilePredictionHistoryState getState() {
        return this.state;
    }

    public final synchronized void saveFileHistory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileHistoryPersistence.INSTANCE.saveFileHistory(project, this.state);
    }

    public final synchronized void onFileOpened(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        RecentFileEntry entry = this.findOrAddEntry(fileUrl, this.recentFilesLimit);
        int code = entry.getCode();
        this.helper.onFileOpened(this.state.getRoot(), code, this.state.getPrevFile());
        this.state.setPrevFile(code);
    }

    private final RecentFileEntry findOrAddEntry(String fileUrl, int limit) {
        int index = this.findEntry(fileUrl);
        int size = this.state.getRecentFiles().size();
        if (index < 0 || index >= size) {
            Integer removedCode = this.trimRecentFilesSize(limit - 1);
            RecentFileEntry newEntry = new RecentFileEntry();
            newEntry.setFileUrl(fileUrl);
            newEntry.setCode(this.nextCode(removedCode));
            this.state.getRecentFiles().add(newEntry);
            return newEntry;
        }
        RecentFileEntry entry = this.state.getRecentFiles().get(index);
        this.state.getRecentFiles().remove(index);
        this.state.getRecentFiles().add(entry);
        return entry;
    }

    private final int nextCode(Integer removed) {
        if (removed != null) {
            return removed;
        }
        int nextFileCode = this.state.getNextFileCode();
        FilePredictionHistoryState filePredictionHistoryState = this.state;
        int n = filePredictionHistoryState.getNextFileCode();
        filePredictionHistoryState.setNextFileCode(n + 1);
        return nextFileCode;
    }

    private final Integer trimRecentFilesSize(int limit) {
        Integer removedCode = null;
        while (this.state.getRecentFiles().size() > limit) {
            int code = this.state.getRecentFiles().remove(0).getCode();
            this.helper.remove(this.state.getRoot(), code);
            removedCode = code;
        }
        return removedCode;
    }

    @NotNull
    public final synchronized FileHistoryFeatures calcHistoryFeatures(@NotNull String fileUrl) {
        int size;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        int index = this.findEntry(fileUrl);
        int n = index;
        boolean fileWasPreviouslyOpened = 0 <= n && (size = this.state.getRecentFiles().size()) > n;
        RecentFileEntry entry = fileWasPreviouslyOpened ? this.state.getRecentFiles().get(index) : null;
        Integer position = fileWasPreviouslyOpened ? Integer.valueOf(size - index - 1) : null;
        RecentFileEntry recentFileEntry = entry;
        NextFileProbability uniGram = this.helper.calculateUniGramProb(this.state.getRoot(), recentFileEntry != null ? Integer.valueOf(recentFileEntry.getCode()) : null);
        RecentFileEntry recentFileEntry2 = entry;
        NextFileProbability biGram = FileSequenceModelHelper.calculateBiGramProb$default(this.helper, this.state.getRoot(), recentFileEntry2 != null ? Integer.valueOf(recentFileEntry2.getCode()) : null, this.state.getPrevFile(), false, 8, null);
        return new FileHistoryFeatures(position, uniGram, biGram);
    }

    private final int findEntry(String fileUrl) {
        int i;
        for (i = this.state.getRecentFiles().size() - 1; i >= 0 && Intrinsics.areEqual((Object)this.state.getRecentFiles().get(i).getFileUrl(), (Object)fileUrl) ^ true; --i) {
        }
        return i;
    }

    public final synchronized int size() {
        return this.state.getRecentFiles().size();
    }

    public final synchronized void cleanup() {
        this.state.getRecentFiles().clear();
        this.state.getRoot().clear();
    }

    public FileHistoryManager(@NotNull FilePredictionHistoryState state, int recentFilesLimit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.recentFilesLimit = recentFilesLimit;
        this.helper = new FileSequenceModelHelper();
    }
}

