/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.fullscreenActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"fullscreenActivityKt", "", "activityClass", "applicationPackage", "layoutName", "packageName", "superClassFqcn", "studio.intellij.android.wizardTemplate.impl"})
public final class FullscreenActivityKtKt {
    @NotNull
    public static final String fullscreenActivityKt(@NotNull String activityClass2, @Nullable String applicationPackage, @NotNull String layoutName2, @NotNull String packageName, @NotNull String superClassFqcn) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkParameterIsNotNull((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)superClassFqcn, (String)"superClassFqcn");
        boolean predicate$iv = applicationPackage != null;
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (predicate$iv) {
            boolean bl = false;
            String string2 = "import " + applicationPackage + ".R";
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        } else {
            String string4 = "[THIS LINE SHOULDN'T BE RENDERED!]";
            boolean bl = false;
            boolean bl3 = false;
            String it$iv = string4;
            boolean bl4 = false;
            bl = false;
            string = string4;
            if (string == null) {
                string = "";
            }
        }
        String applicationPackageBlock = string;
        return "package " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + "\n\nimport " + superClassFqcn + "\nimport android.annotation.SuppressLint\nimport android.os.Bundle\nimport android.os.Handler\nimport android.view.MotionEvent\nimport android.view.View\nimport android.widget.Button\nimport android.widget.LinearLayout\nimport android.widget.TextView\n" + applicationPackageBlock + "\n\n/**\n * An example full-screen activity that shows and hides the system UI (i.e.\n * status bar and navigation/system bar) with user interaction.\n */\nclass " + activityClass2 + " : AppCompatActivity() {\n    private lateinit var fullscreenContent: TextView\n    private lateinit var fullscreenContentControls: LinearLayout\n    private val hideHandler = Handler()\n    @SuppressLint(\"InlinedApi\")\n    private val hidePart2Runnable = Runnable {\n        // Delayed removal of status and navigation bar\n\n        // Note that some of these constants are new as of API 16 (Jelly Bean)\n        // and API 19 (KitKat). It is safe to use them, as they are inlined\n        // at compile-time and do nothing on earlier devices.\n        fullscreenContent.systemUiVisibility =\n                View.SYSTEM_UI_FLAG_LOW_PROFILE or\n                View.SYSTEM_UI_FLAG_FULLSCREEN or\n                View.SYSTEM_UI_FLAG_LAYOUT_STABLE or\n                View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY or\n                View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION or\n                View.SYSTEM_UI_FLAG_HIDE_NAVIGATION\n    }\n    private val showPart2Runnable = Runnable {\n        // Delayed display of UI elements\n        supportActionBar?.show()\n        fullscreenContentControls.visibility = View.VISIBLE\n    }\n    private var isFullscreen: Boolean = false\n\n    private val hideRunnable = Runnable { hide() }\n    /**\n     * Touch listener to use for in-layout UI controls to delay hiding the\n     * system UI. This is to prevent the jarring behavior of controls going away\n     * while interacting with activity UI.\n     */\n    private val delayHideTouchListener = View.OnTouchListener { view, motionEvent ->\n        when (motionEvent.action) {\n            MotionEvent.ACTION_DOWN -> if (AUTO_HIDE) {\n                delayedHide(AUTO_HIDE_DELAY_MILLIS)\n            }\n            MotionEvent.ACTION_UP -> view.performClick()\n            else -> {\n            }\n        }\n        false\n    }\n\n    @SuppressLint(\"ClickableViewAccessibility\")\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n\n        setContentView(R.layout." + layoutName2 + ")\n        supportActionBar?.setDisplayHomeAsUpEnabled(true)\n\n        isFullscreen = true\n\n        // Set up the user interaction to manually show or hide the system UI.\n        fullscreenContent = findViewById(R.id.fullscreen_content)\n        fullscreenContent.setOnClickListener { toggle() }\n\n        fullscreenContentControls = findViewById(R.id.fullscreen_content_controls)\n\n        // Upon interacting with UI controls, delay any scheduled hide()\n        // operations to prevent the jarring behavior of controls going away\n        // while interacting with the UI.\n        findViewById<Button>(R.id.dummy_button).setOnTouchListener(delayHideTouchListener)\n    }\n\n    override fun onPostCreate(savedInstanceState: Bundle?) {\n        super.onPostCreate(savedInstanceState)\n\n        // Trigger the initial hide() shortly after the activity has been\n        // created, to briefly hint to the user that UI controls\n        // are available.\n        delayedHide(100)\n    }\n\n    private fun toggle() {\n        if (isFullscreen) {\n            hide()\n        } else {\n            show()\n        }\n    }\n\n    private fun hide() {\n        // Hide UI first\n        supportActionBar?.hide()\n        fullscreenContentControls.visibility = View.GONE\n        isFullscreen = false\n\n        // Schedule a runnable to remove the status and navigation bar after a delay\n        hideHandler.removeCallbacks(showPart2Runnable)\n        hideHandler.postDelayed(hidePart2Runnable, UI_ANIMATION_DELAY.toLong())\n    }\n\n    private fun show() {\n        // Show the system bar\n        fullscreenContent.systemUiVisibility =\n                View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN or\n                        View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION\n        isFullscreen = true\n\n        // Schedule a runnable to display UI elements after a delay\n        hideHandler.removeCallbacks(hidePart2Runnable)\n        hideHandler.postDelayed(showPart2Runnable, UI_ANIMATION_DELAY.toLong())\n    }\n\n    /**\n     * Schedules a call to hide() in [delayMillis], canceling any\n     * previously scheduled calls.\n     */\n    private fun delayedHide(delayMillis: Int) {\n        hideHandler.removeCallbacks(hideRunnable)\n        hideHandler.postDelayed(hideRunnable, delayMillis.toLong())\n    }\n\n    companion object {\n        /**\n         * Whether or not the system UI should be auto-hidden after\n         * [AUTO_HIDE_DELAY_MILLIS] milliseconds.\n         */\n        private const val AUTO_HIDE = true\n\n        /**\n         * If [AUTO_HIDE] is set, the number of milliseconds to wait after\n         * user interaction before hiding the system UI.\n         */\n        private const val AUTO_HIDE_DELAY_MILLIS = 3000\n\n        /**\n         * Some older devices needs a small delay between UI widget updates\n         * and a change of the status and navigation bar.\n         */\n        private const val UI_ANIMATION_DELAY = 300\n    }\n}\n";
    }
}

