/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.settingsActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"multipleScreenSettingsActivityKt", "", "activityClass", "packageName", "simpleName", "studio.intellij.android.wizardTemplate.impl"})
public final class MultipleScreenSettingsActivityKtKt {
    @NotNull
    public static final String multipleScreenSettingsActivityKt(@NotNull String activityClass2, @NotNull String packageName, @NotNull String simpleName) {
        Intrinsics.checkParameterIsNotNull((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)simpleName, (String)"simpleName");
        return "package " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + "\n\nimport android.os.Bundle\nimport androidx.appcompat.app.AppCompatActivity\nimport androidx.preference.Preference\nimport androidx.preference.PreferenceFragmentCompat\n\nprivate const val TITLE_TAG = \"settingsActivityTitle\"\n\nclass " + activityClass2 + " : AppCompatActivity(),\n        PreferenceFragmentCompat.OnPreferenceStartFragmentCallback {\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        setContentView(R.layout.settings_activity)\n        if (savedInstanceState == null) {\n            supportFragmentManager\n                    .beginTransaction()\n                    .replace(R.id.settings, HeaderFragment())\n                    .commit()\n        } else {\n            title = savedInstanceState.getCharSequence(TITLE_TAG)\n        }\n        supportFragmentManager.addOnBackStackChangedListener {\n            if (supportFragmentManager.backStackEntryCount == 0) {\n                setTitle(R.string.title_" + simpleName + ")\n            }\n        }\n        supportActionBar?.setDisplayHomeAsUpEnabled(true)\n    }\n\n    override fun onSaveInstanceState(outState: Bundle) {\n        super.onSaveInstanceState(outState)\n        // Save current activity title so we can set it again after a configuration change\n        outState.putCharSequence(TITLE_TAG, title)\n    }\n\n    override fun onSupportNavigateUp(): Boolean {\n        if (supportFragmentManager.popBackStackImmediate()) {\n            return true\n        }\n        return super.onSupportNavigateUp()\n    }\n\n    override fun onPreferenceStartFragment(\n            caller: PreferenceFragmentCompat,\n            pref: Preference\n    ): Boolean {\n        // Instantiate the new Fragment\n        val args = pref.extras\n        val fragment = supportFragmentManager.fragmentFactory.instantiate(\n                classLoader,\n                pref.fragment\n        ).apply {\n            arguments = args\n            setTargetFragment(caller, 0)\n        }\n        // Replace the existing Fragment with the new Fragment\n        supportFragmentManager.beginTransaction()\n                .replace(R.id.settings, fragment)\n                .addToBackStack(null)\n                .commit()\n        title = pref.title\n        return true\n    }\n\n    class HeaderFragment : PreferenceFragmentCompat() {\n        override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {\n            setPreferencesFromResource(R.xml.header_preferences, rootKey)\n        }\n    }\n\n    class MessagesFragment : PreferenceFragmentCompat() {\n        override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {\n            setPreferencesFromResource(R.xml.messages_preferences, rootKey)\n        }\n    }\n\n    class SyncFragment : PreferenceFragmentCompat() {\n        override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {\n            setPreferencesFromResource(R.xml.sync_preferences, rootKey)\n        }\n    }\n}\n";
    }
}

