/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferenceScopeOptimizer;", "Lcom/intellij/psi/search/ScopeOptimizer;", "()V", "getRestrictedScopeForTopLevelCallable", "Lcom/intellij/psi/search/GlobalSearchScope;", "callable", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getRestrictedUseScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.fir.frontend-independent"})
public final class KotlinReferenceScopeOptimizer
implements ScopeOptimizer {
    @Nullable
    public SearchScope getRestrictedUseScope(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof KtCallableDeclaration && ((KtCallableDeclaration)element2).getParent() instanceof KtFile) {
            return (SearchScope)this.getRestrictedScopeForTopLevelCallable((KtCallableDeclaration)element2);
        }
        return null;
    }

    private final GlobalSearchScope getRestrictedScopeForTopLevelCallable(KtCallableDeclaration callable) {
        SearchScope searchScope2 = callable.getUseScope();
        if (!(searchScope2 instanceof GlobalSearchScope)) {
            searchScope2 = null;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope2;
        if (globalSearchScope == null) {
            return null;
        }
        GlobalSearchScope useScope2 = globalSearchScope;
        PsiElement psiElement = callable.getParent();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile file = (KtFile)psiElement;
        FqName fqName2 = file.getPackageFqName();
        boolean bl = false;
        boolean bl2 = false;
        FqName it = fqName2;
        boolean bl3 = false;
        Object object = !it.isRoot() ? fqName2 : null;
        if (object == null) {
            return null;
        }
        FqName packageName = object;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"PsiSearchHelper.getInstance(project)");
        PsiSearchHelper searchHelper = psiSearchHelper;
        GlobalSearchScope globalSearchScope2 = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)useScope2, (FileType[])new FileType[]{(FileType)KotlinFileType.INSTANCE});
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"GlobalSearchScope.getSco\u2026 KotlinFileType.INSTANCE)");
        GlobalSearchScope kotlinScope = globalSearchScope2;
        GlobalSearchScope globalSearchScope3 = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)useScope2, (FileType[])new FileType[]{(FileType)JavaFileType.INSTANCE});
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"GlobalSearchScope.getSco\u2026e, JavaFileType.INSTANCE)");
        GlobalSearchScope javaScope = globalSearchScope3;
        SearchScope searchScope3 = (SearchScope)useScope2;
        FileType[] fileTypeArray = new FileType[2];
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        fileTypeArray[0] = (FileType)kotlinFileType;
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"JavaFileType.INSTANCE");
        fileTypeArray[1] = (FileType)javaFileType;
        SearchScope searchScope4 = SearchUtilKt.excludeFileTypes(searchScope3, fileTypeArray);
        if (searchScope4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
        }
        GlobalSearchScope restScope = (GlobalSearchScope)searchScope4;
        boolean bl4 = false;
        List kotlinFiles = new ArrayList();
        searchHelper.processCandidateFilesForText(kotlinScope, (short)1, true, packageName.asString(), (Processor)new Processor<VirtualFile>(kotlinFiles){
            final /* synthetic */ List $kotlinFiles;

            public final boolean process(VirtualFile it) {
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                return this.$kotlinFiles.add(virtualFile);
            }
            {
                this.$kotlinFiles = list;
            }
        });
        boolean bl5 = false;
        List javaFiles = new ArrayList();
        searchHelper.processCandidateFilesForText(javaScope, (short)1, true, JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)file).asString(), (Processor)new Processor<VirtualFile>(javaFiles){
            final /* synthetic */ List $javaFiles;

            public final boolean process(VirtualFile it) {
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                return this.$javaFiles.add(virtualFile);
            }
            {
                this.$javaFiles = list;
            }
        });
        return GlobalSearchScope.filesScope((Project)project2, (Collection)CollectionsKt.plus((Collection)kotlinFiles, (Iterable)javaFiles)).uniteWith(restScope);
    }
}

