/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.SuppressLintQuickFix;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.groovy.GroovyFileType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J%\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/psi/PsiElement;)V", "id", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "label", "getFamilyName", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.android.lint"})
public final class SuppressLintIntentionAction
implements IntentionAction,
Iconable {
    private final String label;
    private final String id;

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = AllIcons.Actions.Cancel;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Cancel");
        return icon;
    }

    @NotNull
    public String getText() {
        return this.label;
    }

    @NotNull
    public String getFamilyName() {
        return "Suppress";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        FileType type = fileType;
        return type == StdFileTypes.JAVA || type == StdFileTypes.XML || type == GroovyFileType.GROOVY_FILE_TYPE || type == KotlinFileType.INSTANCE || file instanceof PsiBinaryFile;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file == null) {
            return;
        }
        if (editor != null) {
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            int elementOffset = caretModel.getOffset();
            PsiElement psiElement = file.findElementAt(elementOffset);
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"file.findElementAt(elementOffset) ?: return");
            PsiElement element = psiElement;
            SuppressLintQuickFix fix = new SuppressLintQuickFix(this.id, element);
            fix.applyFix(element);
        } else {
            new SuppressLintQuickFix(this.id, (PsiElement)file).applyFix((PsiElement)file);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public SuppressLintIntentionAction(@NotNull String id, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.id = id;
        this.label = SuppressLintQuickFix.Companion.displayName(element, this.id);
    }

    public SuppressLintIntentionAction(@NotNull Issue issue, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this(issue.getId(), element);
    }
}

