/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JF\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00120\u0017J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J(\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineCallableUsagesSearcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "checkIfInline", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findInlinedCalls", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "alreadyVisited", "", "Lcom/intellij/psi/PsiElement;", "transformer", "Lkotlin/Function2;", "getScopeForInlineDeclarationUsages", "inlineDeclaration", "processReference", "reference", "Lcom/intellij/psi/PsiReference;", "kotlin.jvm-debugger.core"})
public final class InlineCallableUsagesSearcher {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinDebuggerCaches.ComputedClassNames findInlinedCalls(@NotNull KtDeclaration declaration2, @NotNull Set<? extends PsiElement> alreadyVisited, @NotNull BindingContext bindingContext, @NotNull Function2<? super PsiElement, ? super Set<? extends PsiElement>, KotlinDebuggerCaches.ComputedClassNames> transformer) {
        boolean bl;
        boolean bl2;
        List list;
        block11: {
            void $this$all$iv;
            void $this$flatMapTo$iv$iv;
            KotlinDebuggerCaches.ComputedClassNames it;
            Iterable $this$mapTo$iv$iv;
            ApplicationEx applicationEx;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter(alreadyVisited, (String)"alreadyVisited");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
            if (!this.checkIfInline(declaration2, bindingContext)) {
                return KotlinDebuggerCaches.ComputedClassNames.Companion.getEMPTY();
            }
            boolean bl3 = false;
            HashSet searchResult = new HashSet();
            Object object = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(declaration2){
                final /* synthetic */ KtDeclaration $declaration;

                @NotNull
                public final String invoke() {
                    String string = this.$declaration.getName();
                    if (string == null) {
                        string = "<error>";
                    }
                    return string;
                }
                {
                    this.$declaration = ktDeclaration;
                    super(0);
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { declaration.name ?: \"<error>\" }");
            String declarationName2 = (String)object;
            Runnable task2 = new Runnable(this, declaration2, alreadyVisited, searchResult){
                final /* synthetic */ InlineCallableUsagesSearcher this$0;
                final /* synthetic */ KtDeclaration $declaration;
                final /* synthetic */ Set $alreadyVisited;
                final /* synthetic */ HashSet $searchResult;

                public final void run() {
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)((PsiElement)this.$declaration), (SearchScope)((SearchScope)InlineCallableUsagesSearcher.access$getScopeForInlineDeclarationUsages(this.this$0, this.$declaration)))) {
                        PsiElement psiElement;
                        ProgressManager.checkCanceled();
                        PsiReference psiReference = reference;
                        Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"reference");
                        if (InlineCallableUsagesSearcher.access$processReference(this.this$0, this.$declaration, psiReference, this.$alreadyVisited) == null) continue;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiElement it = psiElement;
                        boolean bl3 = false;
                        Collection collection = this.$searchResult;
                        boolean bl4 = false;
                        collection.add(it);
                    }
                }
                {
                    this.this$0 = inlineCallableUsagesSearcher;
                    this.$declaration = ktDeclaration;
                    this.$alreadyVisited = set;
                    this.$searchResult = hashSet;
                }
            };
            boolean isSuccess = true;
            ApplicationEx applicationEx2 = applicationEx = ApplicationManagerEx.getApplicationEx();
            Intrinsics.checkNotNullExpressionValue((Object)applicationEx2, (String)"applicationEx");
            if (applicationEx2.isDispatchThread()) {
                isSuccess = ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, KotlinDebuggerCoreBundle.message("find.inline.calls.task.compute.names", declarationName2), true, this.project);
            } else {
                try {
                    ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)new EmptyProgressIndicator());
                }
                catch (InterruptedException e) {
                    isSuccess = false;
                }
            }
            if (!isSuccess) {
                String string = KotlinDebuggerCoreBundle.message("find.inline.calls.task.cancelled", declarationName2);
                MessageType messageType = MessageType.WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.WARNING");
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(string, messageType).notify(this.project);
            }
            HashSet<KtDeclaration> hashSet = new HashSet<KtDeclaration>();
            boolean bl4 = false;
            boolean bl5 = false;
            Iterable<Object> $this$apply = hashSet;
            boolean bl6 = false;
            $this$apply.addAll(alreadyVisited);
            $this$apply.addAll(searchResult);
            $this$apply.add(declaration2);
            HashSet<KtDeclaration> newAlreadyVisited = hashSet;
            Iterable $this$map$iv = searchResult;
            boolean $i$f$map = false;
            $this$apply = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                KotlinDebuggerCaches.ComputedClassNames computedClassNames = (KotlinDebuggerCaches.ComputedClassNames)transformer.invoke((Object)it, newAlreadyVisited);
                collection.add(computedClassNames);
            }
            List results = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = results;
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (KotlinDebuggerCaches.ComputedClassNames)element$iv$iv;
                boolean bl8 = false;
                Iterable list$iv$iv = it.getClassNames();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
            $this$flatMap$iv = results;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinDebuggerCaches.ComputedClassNames it2 = (KotlinDebuggerCaches.ComputedClassNames)element$iv;
                    boolean bl9 = false;
                    if (it2.getShouldBeCached()) continue;
                    bl2 = false;
                    break block11;
                }
                bl2 = true;
            }
        }
        boolean bl10 = bl = bl2;
        List list2 = list;
        return new KotlinDebuggerCaches.ComputedClassNames(list2, bl10);
    }

    public static /* synthetic */ KotlinDebuggerCaches.ComputedClassNames findInlinedCalls$default(InlineCallableUsagesSearcher inlineCallableUsagesSearcher, KtDeclaration ktDeclaration, Set set, BindingContext bindingContext, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            bindingContext = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper((PsiElement)ktDeclaration).getBindingContext();
        }
        return inlineCallableUsagesSearcher.findInlinedCalls(ktDeclaration, set, bindingContext, (Function2<? super PsiElement, ? super Set<? extends PsiElement>, KotlinDebuggerCaches.ComputedClassNames>)function2);
    }

    private final PsiElement processReference(KtDeclaration declaration2, PsiReference reference, Set<? extends PsiElement> alreadyVisited) {
        KtElement ktElement;
        block6: {
            block5: {
                if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(reference){
                    final /* synthetic */ PsiReference $reference;

                    public final boolean invoke() {
                        return SearchUtilKt.isImportUsage((PsiReference)this.$reference);
                    }
                    {
                        this.$reference = psiReference;
                        super(0);
                    }
                }))).booleanValue()) {
                    return null;
                }
                PsiElement psiElement = reference.getElement();
                if (!(psiElement instanceof KtElement)) {
                    psiElement = null;
                }
                if ((ktElement = (KtElement)psiElement) == null) break block5;
                KtElement ktElement2 = ktElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement p1 = (PsiElement)ktElement2;
                boolean bl3 = false;
                ktElement = DebuggerClassNameProvider.Companion.getRelevantElement$kotlin_jvm_debugger_core(p1);
                if (ktElement != null) break block6;
            }
            return null;
        }
        KtElement usage = ktElement;
        boolean shouldAnalyze2 = (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(declaration2, (PsiElement)usage, alreadyVisited){
            final /* synthetic */ KtDeclaration $declaration;
            final /* synthetic */ PsiElement $usage;
            final /* synthetic */ Set $alreadyVisited;

            public final boolean invoke() {
                return !PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)this.$declaration), (PsiElement)this.$usage, (boolean)false, (int)2, null) && !this.$alreadyVisited.contains(this.$usage);
            }
            {
                this.$declaration = ktDeclaration;
                this.$usage = psiElement;
                this.$alreadyVisited = set;
                super(0);
            }
        }));
        return shouldAnalyze2 ? usage : null;
    }

    private final boolean checkIfInline(KtDeclaration declaration2, BindingContext bindingContext) {
        DeclarationDescriptor descriptor;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration2);
        if (declarationDescriptor == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"bindingContext.get(Bindi\u2026laration) ?: return false");
        DeclarationDescriptor declarationDescriptor2 = descriptor = declarationDescriptor;
        return declarationDescriptor2 instanceof FunctionDescriptor ? InlineUtil.isInline((DeclarationDescriptor)descriptor) : (declarationDescriptor2 instanceof PropertyDescriptor ? InlineUtil.hasInlineAccessors((PropertyDescriptor)((PropertyDescriptor)descriptor)) : false);
    }

    private final GlobalSearchScope getScopeForInlineDeclarationUsages(KtDeclaration inlineDeclaration) {
        GlobalSearchScope globalSearchScope;
        VirtualFile virtualFile2 = (VirtualFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>(inlineDeclaration){
            final /* synthetic */ KtDeclaration $inlineDeclaration;

            public final VirtualFile invoke() {
                PsiFile psiFile = this.$inlineDeclaration.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"inlineDeclaration.containingFile");
                return psiFile.getVirtualFile();
            }
            {
                this.$inlineDeclaration = ktDeclaration;
                super(0);
            }
        }));
        if (virtualFile2 != null && ProjectRootsUtil.isLibraryFile((Project)this.project, (VirtualFile)virtualFile2)) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"GlobalSearchScope.allScope(project)");
            GlobalSearchScope globalSearchScope3 = this.searchScope.uniteWith(KotlinSourceFilterScope.Companion.librarySources(globalSearchScope2, this.project));
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"searchScope.uniteWith(\n \u2026), project)\n            )");
        } else {
            globalSearchScope = this.searchScope;
        }
        return globalSearchScope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    public InlineCallableUsagesSearcher(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        this.project = project;
        this.searchScope = searchScope;
    }

    public static final /* synthetic */ GlobalSearchScope access$getScopeForInlineDeclarationUsages(InlineCallableUsagesSearcher $this, KtDeclaration inlineDeclaration) {
        return $this.getScopeForInlineDeclarationUsages(inlineDeclaration);
    }

    public static final /* synthetic */ PsiElement access$processReference(InlineCallableUsagesSearcher $this, KtDeclaration declaration2, PsiReference reference, Set alreadyVisited) {
        return $this.processReference(declaration2, reference, alreadyVisited);
    }
}

