/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.fest.util.Preconditions;

public final class Sets {
    private Sets() {
    }

    @Nonnull
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @Nonnull
    public static <T> HashSet<T> newHashSet(@Nonnull Iterable<? extends T> elements) {
        HashSet<T> set = Sets.newHashSet();
        for (T e : elements) {
            set.add(e);
        }
        return set;
    }

    @Nonnull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @Nonnull
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        Preconditions.checkNotNull(elements);
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, elements);
        return set;
    }
}

