/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.progress.ProgressVisibilityManager;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsHost;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsPanel;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsPanelKt;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountDecorator;
import org.jetbrains.plugins.github.authentication.util.GHSecurityUtil;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.util.JListHoveredRowMaterialiser;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.GithubImageResizer;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u001a\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001:B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0006\u0010\"\u001a\u00020\u001dJ\r\u0010#\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001dH\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0010H\u0002J\"\u0010(\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150)J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0016H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010/\u001a\u00020.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0015012\b\u00102\u001a\u0004\u0018\u00010\u0015J\u0010\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u00020\u0010H\u0002J\u0006\u00105\u001a\u00020\u001dJ&\u00106\u001a\u00020\u001d2\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\b\u00102\u001a\u0004\u0018\u00010\u0015J\u0010\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u000209H\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsHost;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "avatarLoader", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "imageResizer", "Lorg/jetbrains/plugins/github/util/GithubImageResizer;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;Lorg/jetbrains/plugins/github/util/GithubImageResizer;)V", "accountList", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecorator;", "accountListModel", "Lcom/intellij/ui/CollectionListModel;", "currentTokensMap", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "newTokensMap", "", "progressManager", "org/jetbrains/plugins/github/authentication/ui/GHAccountsPanel$createListProgressManager$1", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsPanel$createListProgressManager$1;", "addAccount", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "login", "token", "clearNewTokens", "createListProgressManager", "()Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsPanel$createListProgressManager$1;", "dispose", "editAccount", "decorator", "getAccounts", "Lkotlin/Pair;", "getData", "", "dataId", "isAccountUnique", "", "isModified", "accounts", "", "defaultAccount", "loadAccountDetails", "accountData", "loadExistingAccountsDetails", "setAccounts", "showAddAccountActions", "point", "Lcom/intellij/ui/awt/RelativePoint;", "GithubAccountDecoratorRenderer", "intellij.vcs.github"})
public final class GHAccountsPanel
extends BorderLayoutPanel
implements GHAccountsHost,
Disposable,
DataProvider {
    private final CollectionListModel<GithubAccountDecorator> accountListModel;
    private final JBList<GithubAccountDecorator> accountList;
    private final createListProgressManager.1 progressManager;
    private Map<GithubAccount, String> currentTokensMap;
    private final Map<GithubAccount, String> newTokensMap;
    private final Project project;
    private final GithubApiRequestExecutor.Factory executorFactory;
    private final CachingGithubUserAvatarLoader avatarLoader;
    private final GithubImageResizer imageResizer;

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return GHAccountsHost.Companion.getKEY().is(dataId) ? this : null;
    }

    private final void showAddAccountActions(RelativePoint point) {
        AnAction anAction = GHAccountsPanelKt.access$getActionManager$p().getAction("Github.Accounts.AddAccount");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup group = (ActionGroup)anAction;
        ActionPopupMenu actionPopupMenu = GHAccountsPanelKt.access$getActionManager$p().createActionPopupMenu("unknown", group);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"actionManager.createActi\u2026ionPlaces.UNKNOWN, group)");
        ActionPopupMenu popup = actionPopupMenu;
        popup.setTargetComponent((JComponent)((Object)this));
        JBPopupMenu.showAt((RelativePoint)point, (JPopupMenu)popup.getComponent());
    }

    private final void editAccount(GithubAccountDecorator decorator) {
        GHAccountAuthData authData2 = GithubAuthenticationManager.Companion.getInstance().login$intellij_vcs_github(this.project, (Component)((Object)this), new GHLoginRequest(null, null, decorator.getAccount().getServer(), false, decorator.getAccount().getName(), false, false, null, null, 491, null));
        if (authData2 == null) {
            return;
        }
        decorator.getAccount().setName(authData2.getLogin());
        this.newTokensMap.put(decorator.getAccount(), authData2.getToken());
        this.loadAccountDetails(decorator);
    }

    @Override
    public void addAccount(@NotNull GithubServerPath server, @NotNull String login2, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        GithubAccount githubAccount = GithubAccountManager.Companion.createAccount(login2, server);
        this.newTokensMap.put(githubAccount, token);
        GithubAccountDecorator accountData = new GithubAccountDecorator(githubAccount, false);
        this.accountListModel.add((Object)accountData);
        this.loadAccountDetails(accountData);
    }

    @Override
    public boolean isAccountUnique(@NotNull String login2, @NotNull GithubServerPath server) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"accountListModel.items");
            Iterable $this$none$iv = list2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GithubAccountDecorator it = (GithubAccountDecorator)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getAccount().getName(), (Object)login2) && it.getAccount().getServer().equals(server, true))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void loadExistingAccountsDetails() {
        Iterator iterator = this.accountListModel.getItems().iterator();
        while (iterator.hasNext()) {
            GithubAccountDecorator accountData;
            GithubAccountDecorator githubAccountDecorator = accountData = (GithubAccountDecorator)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)githubAccountDecorator, (String)"accountData");
            this.loadAccountDetails(githubAccountDecorator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAccountDetails(GithubAccountDecorator accountData) {
        String token;
        GithubAccount account = accountData.getAccount();
        String string = this.newTokensMap.get(account);
        if (string == null) {
            string = token = this.currentTokensMap.get(account);
        }
        if (token == null) {
            void $this$apply;
            GithubAccountDecorator githubAccountDecorator = accountData;
            boolean bl = false;
            boolean bl2 = false;
            GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
            CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
            boolean bl3 = false;
            $this$apply.setErrorText(GithubBundle.message("account.token.missing", new Object[0]));
            $this$apply.setShowReLoginLink(true);
            Unit unit = Unit.INSTANCE;
            collectionListModel.contentsChanged((Object)githubAccountDecorator);
            return;
        }
        GithubApiRequestExecutor.WithTokenAuth executor = this.executorFactory.create(token);
        this.progressManager.run(new Task.Backgroundable(this, executor, account, accountData, this.project, GithubBundle.message("progress.title.not.visible", new Object[0])){
            @NotNull
            public GithubAuthenticatedUser loadedDetails;
            private boolean correctScopes;
            final /* synthetic */ GHAccountsPanel this$0;
            final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $executor;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ GithubAccountDecorator $accountData;

            @NotNull
            public final GithubAuthenticatedUser getLoadedDetails() {
                GithubAuthenticatedUser githubAuthenticatedUser = this.loadedDetails;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loadedDetails");
                }
                return githubAuthenticatedUser;
            }

            public final void setLoadedDetails(@NotNull GithubAuthenticatedUser githubAuthenticatedUser) {
                Intrinsics.checkNotNullParameter((Object)githubAuthenticatedUser, (String)"<set-?>");
                this.loadedDetails = githubAuthenticatedUser;
            }

            public final boolean getCorrectScopes() {
                return this.correctScopes;
            }

            public final void setCorrectScopes(boolean bl) {
                this.correctScopes = bl;
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void details2;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GithubApiRequestExecutor githubApiRequestExecutor = this.$executor;
                GithubServerPath githubServerPath = this.$account.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"account.server");
                Object object = GHSecurityUtil.loadCurrentUserWithScopes$intellij_vcs_github(githubApiRequestExecutor, indicator, githubServerPath);
                GithubAuthenticatedUser githubAuthenticatedUser = (GithubAuthenticatedUser)object.component1();
                String scopes = (String)object.component2();
                this.loadedDetails = details2;
                object = scopes;
                boolean bl = false;
                Object object2 = object;
                if (object2 == null) {
                    object2 = "";
                }
                this.correctScopes = GHSecurityUtil.isEnoughScopes$intellij_vcs_github(object2);
            }

            /*
             * WARNING - void declaration
             */
            public void onSuccess() {
                void $this$apply;
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                boolean bl = false;
                boolean bl2 = false;
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                CollectionListModel collectionListModel = GHAccountsPanel.access$getAccountListModel$p(this.this$0);
                boolean bl3 = false;
                GithubAuthenticatedUser githubAuthenticatedUser = this.loadedDetails;
                if (githubAuthenticatedUser == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loadedDetails");
                }
                $this$apply.setDetails(githubAuthenticatedUser);
                $this$apply.setIconProvider(new CachingGithubAvatarIconsProvider(GHAccountsPanel.access$getAvatarLoader$p(this.this$0), GHAccountsPanel.access$getImageResizer$p(this.this$0), this.$executor, GithubUIUtil.INSTANCE.getAvatarSize(), (Component)GHAccountsPanel.access$getAccountList$p(this.this$0)));
                if (this.correctScopes) {
                    $this$apply.setErrorText(null);
                    $this$apply.setShowReLoginLink(false);
                } else {
                    $this$apply.setErrorText("Insufficient security scopes");
                    $this$apply.setShowReLoginLink(true);
                }
                Unit unit = Unit.INSTANCE;
                collectionListModel.contentsChanged((Object)githubAccountDecorator);
            }

            /*
             * WARNING - void declaration
             */
            public void onThrowable(@NotNull Throwable error) {
                void $this$apply;
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                GithubAccountDecorator githubAccountDecorator = this.$accountData;
                boolean bl = false;
                boolean bl2 = false;
                GithubAccountDecorator githubAccountDecorator2 = githubAccountDecorator;
                CollectionListModel collectionListModel = GHAccountsPanel.access$getAccountListModel$p(this.this$0);
                boolean bl3 = false;
                $this$apply.setErrorText(String.valueOf(error.getMessage()));
                $this$apply.setShowReLoginLink(error instanceof GithubAuthenticationException);
                Unit unit = Unit.INSTANCE;
                collectionListModel.contentsChanged((Object)githubAccountDecorator);
            }
            {
                this.this$0 = this$0;
                this.$executor = $captured_local_variable$1;
                this.$account = $captured_local_variable$2;
                this.$accountData = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
                this.correctScopes = true;
            }
        });
    }

    private final createListProgressManager.1 createListProgressManager() {
        return new ProgressVisibilityManager(this){
            final /* synthetic */ GHAccountsPanel this$0;

            protected void setProgressVisible(boolean visible) {
                GHAccountsPanel.access$getAccountList$p(this.this$0).setPaintBusy(visible);
            }

            @NotNull
            protected ModalityState getModalityState() {
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.any()");
                return modalityState;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccounts(@NotNull Map<GithubAccount, String> accounts, @Nullable GithubAccount defaultAccount) {
        Collection<GithubAccountDecorator> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
        this.accountListModel.removeAll();
        Iterable iterable = accounts.keySet();
        int n = 0;
        CollectionListModel<GithubAccountDecorator> collectionListModel = this.accountListModel;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GithubAccount githubAccount = (GithubAccount)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GithubAccountDecorator githubAccountDecorator = new GithubAccountDecorator((GithubAccount)it, Intrinsics.areEqual((Object)it, (Object)defaultAccount));
            collection.add(githubAccountDecorator);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.addAll(n, (List)collection);
        this.currentTokensMap = accounts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Map<GithubAccount, String>, GithubAccount> getAccounts() {
        Object v2;
        Map map2;
        block2: {
            void $this$associateTo$iv$iv;
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"accountListModel.items");
            Iterable $this$associate$iv = list2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                GithubAccountDecorator it = (GithubAccountDecorator)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getAccount(), (Object)this.newTokensMap.get(it.getAccount()));
                boolean bl2 = false;
                map3.put(pair.getFirst(), pair.getSecond());
            }
            List list3 = this.accountListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"accountListModel.items");
            Iterable iterable2 = list3;
            map2 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable3 = iterable2;
            boolean bl3 = false;
            for (Object t : iterable3) {
                GithubAccountDecorator it = (GithubAccountDecorator)t;
                boolean bl4 = false;
                if (!it.getProjectDefault()) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        Object var13_17 = v2;
        GithubAccountDecorator githubAccountDecorator = var13_17;
        return TuplesKt.to((Object)map2, (Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null));
    }

    public final void clearNewTokens() {
        this.newTokensMap.clear();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModified(@NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount) {
        void $this$mapTo$iv$iv;
        Object v1;
        Iterable iterable;
        boolean bl;
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
            List list2 = this.accountListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"accountListModel.items");
            object = list2;
            bl = false;
            iterable = object;
            boolean bl2 = false;
            for (Object object2 : iterable) {
                GithubAccountDecorator it = (GithubAccountDecorator)object2;
                boolean bl3 = false;
                if (!it.getProjectDefault()) continue;
                v1 = object2;
                break block2;
            }
            v1 = null;
        }
        GithubAccountDecorator githubAccountDecorator = v1;
        if (Intrinsics.areEqual((Object)(githubAccountDecorator != null ? githubAccountDecorator.getAccount() : null), (Object)defaultAccount) ^ true) return true;
        List list3 = this.accountListModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"accountListModel.items");
        Iterable $this$map$iv = list3;
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GithubAccountDecorator bl3 = (GithubAccountDecorator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            GithubAccount githubAccount = it.getAccount();
            collection.add(githubAccount);
        }
        if (Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), accounts) ^ true) return true;
        object = this.newTokensMap;
        bl = false;
        if (object.isEmpty()) return false;
        return true;
    }

    public void dispose() {
    }

    public GHAccountsPanel(@NotNull Project project, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull CachingGithubUserAvatarLoader avatarLoader, @NotNull GithubImageResizer imageResizer) {
        StatusText $this$apply;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter((Object)avatarLoader, (String)"avatarLoader");
        Intrinsics.checkNotNullParameter((Object)imageResizer, (String)"imageResizer");
        this.project = project;
        this.executorFactory = executorFactory;
        this.avatarLoader = avatarLoader;
        this.imageResizer = imageResizer;
        this.accountListModel = new CollectionListModel((Object[])new GithubAccountDecorator[0]);
        JBList jBList = new JBList((ListModel)this.accountListModel);
        boolean bl = false;
        boolean bl2 = false;
        JBList jBList2 = jBList;
        GHAccountsPanel gHAccountsPanel = this;
        boolean bl3 = false;
        GithubAccountDecoratorRenderer decoratorRenderer = new GithubAccountDecoratorRenderer();
        $this$apply.setCellRenderer((ListCellRenderer)decoratorRenderer);
        JListHoveredRowMaterialiser.Companion.install((JList)$this$apply, new GithubAccountDecoratorRenderer());
        UIUtil.putClientProperty((JComponent)((JComponent)$this$apply), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)CollectionsKt.listOf((Object)decoratorRenderer));
        $this$apply.setSelectionMode(0);
        Unit unit = Unit.INSTANCE;
        gHAccountsPanel.accountList = jBList;
        this.progressManager = this.createListProgressManager();
        boolean bl4 = false;
        this.currentTokensMap = MapsKt.emptyMap();
        bl4 = false;
        this.newTokensMap = new LinkedHashMap();
        StatusText statusText = this.accountList.getEmptyText();
        bl = false;
        bl2 = false;
        $this$apply = statusText;
        boolean bl5 = false;
        $this$apply.appendText(GithubBundle.message("accounts.none.added", new Object[0]));
        $this$apply.appendSecondaryText(GithubBundle.message("accounts.add", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, new ActionListener(this){
            final /* synthetic */ GHAccountsPanel this$0;
            {
                this.this$0 = gHAccountsPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                ActionUtil.invokeAction((AnAction)GHAccountsPanelKt.access$getActionManager$p().getAction("Github.Accounts.AddGHAccount"), (Component)((Component)GHAccountsPanel.access$getAccountList$p(this.this$0)), (String)"unknown", null, null);
            }
        });
        $this$apply.appendSecondaryText(" (" + KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getNew()) + ')', StatusText.DEFAULT_ATTRIBUTES, null);
        this.addToCenter(ToolbarDecorator.createDecorator((JList)((JList)this.accountList)).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public final void run(AnActionButton it) {
                AnActionButton anActionButton = it;
                Intrinsics.checkNotNullExpressionValue((Object)anActionButton, (String)"it");
                RelativePoint relativePoint = anActionButton.getPreferredPopupPoint();
                if (relativePoint == null) {
                    relativePoint = RelativePoint.getCenterOf((JComponent)((JComponent)accountList));
                }
                Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"it.preferredPopupPoint ?: getCenterOf(accountList)");
                this.showAddAccountActions(relativePoint);
            }
        }).addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(GithubBundle.message("accounts.set.default", new Object[0]), AllIcons.Actions.Checked){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault()) {
                    return;
                }
                for (GithubAccountDecorator accountData : accountListModel.getItems()) {
                    if (Intrinsics.areEqual((Object)accountData, (Object)((GithubAccountDecorator)accountList.getSelectedValue()))) {
                        accountData.setProjectDefault(true);
                        accountListModel.contentsChanged((Object)accountData);
                        continue;
                    }
                    if (!accountData.getProjectDefault()) continue;
                    accountData.setProjectDefault(false);
                    accountListModel.contentsChanged((Object)accountData);
                }
            }

            public void updateButton(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setEnabled(this.isEnabled() && !((GithubAccountDecorator)accountList.getSelectedValue()).getProjectDefault());
            }
        }).createPanel());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.progressManager));
    }

    public static final /* synthetic */ void access$editAccount(GHAccountsPanel $this, GithubAccountDecorator decorator) {
        $this.editAccount(decorator);
    }

    public static final /* synthetic */ CachingGithubUserAvatarLoader access$getAvatarLoader$p(GHAccountsPanel $this) {
        return $this.avatarLoader;
    }

    public static final /* synthetic */ GithubImageResizer access$getImageResizer$p(GHAccountsPanel $this) {
        return $this.imageResizer;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsPanel$GithubAccountDecoratorRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountDecorator;", "Ljavax/swing/JPanel;", "(Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsPanel;)V", "accountName", "Ljavax/swing/JLabel;", "fullName", "loadingError", "profilePicture", "reloginLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "serverName", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "setBold", "", "isBold", "intellij.vcs.github"})
    private final class GithubAccountDecoratorRenderer
    extends JPanel
    implements ListCellRenderer<GithubAccountDecorator> {
        private final JLabel accountName = new JLabel();
        private final JLabel serverName = new JLabel();
        private final JLabel profilePicture = new JLabel();
        private final JLabel fullName = new JLabel();
        private final JLabel loadingError = new JLabel();
        private final LinkLabel<Object> reloginLink = new LinkLabel(GithubBundle.message("login.action", new Object[0]), null);

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends GithubAccountDecorator> list2, @NotNull GithubAccountDecorator value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            UIUtil.setBackgroundRecursively((Component)this, (Color)ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected, list2.hasFocus()));
            Color primaryTextColor = ListUiUtil.WithTallRow.INSTANCE.foreground(isSelected, list2.hasFocus());
            Color secondaryTextColor = ListUiUtil.WithTallRow.INSTANCE.secondaryForeground(list2, isSelected);
            LinkLabel<Object> linkLabel = this.accountName;
            boolean bl = false;
            boolean bl2 = false;
            LinkLabel<Object> $this$apply = linkLabel;
            boolean bl3 = false;
            $this$apply.setText(value.getAccount().getName());
            GithubAuthenticatedUser githubAuthenticatedUser = value.getDetails();
            this.setBold((JLabel)$this$apply, (githubAuthenticatedUser != null ? githubAuthenticatedUser.getName() : null) == null ? value.getProjectDefault() : false);
            GithubAuthenticatedUser githubAuthenticatedUser2 = value.getDetails();
            $this$apply.setForeground((githubAuthenticatedUser2 != null ? githubAuthenticatedUser2.getName() : null) == null ? primaryTextColor : secondaryTextColor);
            linkLabel = this.serverName;
            bl = false;
            bl2 = false;
            $this$apply = linkLabel;
            boolean bl4 = false;
            $this$apply.setText(value.getAccount().getServer().toString());
            $this$apply.setForeground(secondaryTextColor);
            linkLabel = this.profilePicture;
            bl = false;
            bl2 = false;
            $this$apply = linkLabel;
            boolean bl5 = false;
            $this$apply.setIcon(value.getIcon());
            linkLabel = this.fullName;
            bl = false;
            bl2 = false;
            $this$apply = linkLabel;
            boolean bl6 = false;
            GithubAuthenticatedUser githubAuthenticatedUser3 = value.getDetails();
            $this$apply.setText(githubAuthenticatedUser3 != null ? githubAuthenticatedUser3.getName() : null);
            this.setBold((JLabel)$this$apply, value.getProjectDefault());
            GithubAuthenticatedUser githubAuthenticatedUser4 = value.getDetails();
            $this$apply.setVisible((githubAuthenticatedUser4 != null ? githubAuthenticatedUser4.getName() : null) != null);
            $this$apply.setForeground(primaryTextColor);
            linkLabel = this.loadingError;
            bl = false;
            bl2 = false;
            $this$apply = linkLabel;
            boolean bl7 = false;
            $this$apply.setText(value.getErrorText());
            $this$apply.setForeground(UIUtil.getErrorForeground());
            linkLabel = this.reloginLink;
            bl = false;
            bl2 = false;
            $this$apply = linkLabel;
            boolean bl8 = false;
            $this$apply.setVisible(value.getErrorText() != null && value.getShowReLoginLink());
            $this$apply.setListener((LinkListener)new LinkListener<Object>(this, value){
                final /* synthetic */ GithubAccountDecoratorRenderer this$0;
                final /* synthetic */ GithubAccountDecorator $value$inlined;
                {
                    this.this$0 = githubAccountDecoratorRenderer;
                    this.$value$inlined = githubAccountDecorator;
                }

                public final void linkSelected(LinkLabel<Object> $noName_0, @Nullable Object $noName_1) {
                    GHAccountsPanel.access$editAccount(this.this$0.GHAccountsPanel.this, this.$value$inlined);
                }
            }, null);
            return this;
        }

        private final void setBold(JLabel $this$setBold, boolean isBold) {
            int n;
            Font font = $this$setBold.getFont();
            if (isBold) {
                Font font2 = $this$setBold.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
                n = font2.getStyle() | 1;
            } else {
                Font font3 = $this$setBold.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"font");
                n = font3.getStyle() & ~1;
            }
            $this$setBold.setFont(font.deriveFont(n));
        }

        public GithubAccountDecoratorRenderer() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
            JPanel jPanel = new JPanel();
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply = jPanel;
            boolean bl3 = false;
            $this$apply.setLayout(new GridBagLayout());
            $this$apply.setBorder((Border)JBUI.Borders.empty((int)0, (int)6, (int)4, (int)6));
            GridBag gridBag = new GridBag().setDefaultInsets((Insets)JBUI.insetsRight((int)10)).setDefaultAnchor(17).setDefaultFill(3);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag()\n          .set\u2026dBagConstraints.VERTICAL)");
            GridBag bag = gridBag;
            $this$apply.add((Component)this.fullName, bag.nextLine().next());
            $this$apply.add((Component)this.accountName, bag.next());
            $this$apply.add((Component)this.loadingError, bag.next());
            $this$apply.add((Component)this.reloginLink, bag.next());
            $this$apply.add((Component)this.serverName, bag.nextLine().coverLine());
            JPanel namesPanel = jPanel;
            this.add(this.profilePicture);
            this.add(namesPanel);
        }
    }
}

