/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ManagerThreadExecutorKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.KeyMouseEvent;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.XCoroutineView;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.XDebuggerTreeSelectedNodeListenerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/XDebuggerTreeSelectedNodeListener;", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;)V", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "javaDebugProcess", "Lcom/intellij/debugger/engine/JavaDebugProcess;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getTree", "()Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "installOn", "", "nodeSelected", "", "event", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/KeyMouseEvent;", "setCurrentStackFrame", "executionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "kotlin.jvm-debugger.coroutines"})
public final class XDebuggerTreeSelectedNodeListener {
    private final JavaDebugProcess javaDebugProcess;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final XDebuggerTree tree;

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public final void installOn() {
        new DoubleClickListener(this){
            final /* synthetic */ XDebuggerTreeSelectedNodeListener this$0;

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.nodeSelected(new KeyMouseEvent(e));
            }
            {
                this.this$0 = this$0;
            }
        }.installOn((Component)this.tree);
        this.tree.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ XDebuggerTreeSelectedNodeListener this$0;

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int key = e.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    this.this$0.nodeSelected(new KeyMouseEvent(e));
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final boolean nodeSelected(@NotNull KeyMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        XValueNodeImpl[] selectedNodes = (XValueNodeImpl[])this.tree.getSelectedNodes(XValueNodeImpl.class, null);
        if (selectedNodes.length == 1) {
            XValueNodeImpl node;
            XValueNodeImpl xValueNodeImpl = node = selectedNodes[0];
            Intrinsics.checkNotNullExpressionValue((Object)xValueNodeImpl, (String)"node");
            XValue xValue = (XValue)xValueNodeImpl.getValueContainer();
            Intrinsics.checkNotNullExpressionValue((Object)xValue, (String)"node.valueContainer");
            XValue valueContainer = xValue;
            SuspendContextImpl suspendContext = CoroutineUtilsKt.suspendContextImpl(this.session);
            if (valueContainer instanceof XCoroutineView.CoroutineFrameValue) {
                JavaExecutionStack executionStack;
                JavaExecutionStack javaExecutionStack;
                CoroutineStackFrameItem frameItem = ((XCoroutineView.CoroutineFrameValue)valueContainer).getFrameItem();
                XStackFrame xStackFrame = frameItem.createFrame(this.debugProcess);
                if (xStackFrame == null) {
                    return false;
                }
                XStackFrame frame = xStackFrame;
                if (frameItem instanceof RunningCoroutineStackFrameItem) {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = ((RunningCoroutineStackFrameItem)frameItem).getFrame().threadProxy();
                    Intrinsics.checkNotNullExpressionValue((Object)threadReferenceProxyImpl, (String)"frameItem.frame.threadProxy()");
                    javaExecutionStack = XDebuggerTreeSelectedNodeListenerKt.createExecutionStack(threadReferenceProxyImpl, this.debugProcess);
                } else {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContext.getThread();
                    if (threadReferenceProxyImpl != null) {
                        ThreadReferenceProxyImpl threadReferenceProxyImpl2 = threadReferenceProxyImpl;
                        boolean bl = false;
                        boolean bl2 = false;
                        ThreadReferenceProxyImpl it = threadReferenceProxyImpl2;
                        boolean bl3 = false;
                        ThreadReferenceProxyImpl threadReferenceProxyImpl3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)threadReferenceProxyImpl3, (String)"it");
                        javaExecutionStack = XDebuggerTreeSelectedNodeListenerKt.createExecutionStack(threadReferenceProxyImpl3, this.debugProcess);
                    } else {
                        javaExecutionStack = executionStack = null;
                    }
                }
                if (executionStack != null) {
                    this.setCurrentStackFrame((XExecutionStack)executionStack, frame);
                }
            }
        }
        return false;
    }

    public final void setCurrentStackFrame(@NotNull XExecutionStack executionStack, @NotNull XStackFrame stackFrame) {
        Intrinsics.checkNotNullParameter((Object)executionStack, (String)"executionStack");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        XSourcePosition xSourcePosition = stackFrame.getSourcePosition();
        if (xSourcePosition == null || (xSourcePosition = xSourcePosition.getFile()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)xSourcePosition, (String)"stackFrame.sourcePosition?.file ?: return");
        XSourcePosition fileToNavigate = xSourcePosition;
        boolean isKotlinInternalCompiledFile = ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile$default((VirtualFile)fileToNavigate, null, (int)2, null);
        if (!isKotlinInternalCompiledFile) {
            ManagerThreadExecutorKt.invokeLater((Component)this.tree, (Function0<Unit>)((Function0)new Function0<Unit>(this, executionStack, stackFrame){
                final /* synthetic */ XDebuggerTreeSelectedNodeListener this$0;
                final /* synthetic */ XExecutionStack $executionStack;
                final /* synthetic */ XStackFrame $stackFrame;

                public final void invoke() {
                    this.this$0.getSession().setCurrentStackFrame(this.$executionStack, this.$stackFrame, false);
                }
                {
                    this.this$0 = xDebuggerTreeSelectedNodeListener;
                    this.$executionStack = xExecutionStack;
                    this.$stackFrame = xStackFrame;
                    super(0);
                }
            }));
        }
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final XDebuggerTree getTree() {
        return this.tree;
    }

    public XDebuggerTreeSelectedNodeListener(@NotNull XDebugSession session, @NotNull XDebuggerTree tree) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.session = session;
        this.tree = tree;
        XDebugProcess xDebugProcess = this.session.getDebugProcess();
        if (xDebugProcess == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.debugger.engine.JavaDebugProcess");
        }
        this.javaDebugProcess = (JavaDebugProcess)xDebugProcess;
        DebuggerSession debuggerSession = this.javaDebugProcess.getDebuggerSession();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerSession, (String)"javaDebugProcess.debuggerSession");
        DebugProcessImpl debugProcessImpl = debuggerSession.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"javaDebugProcess.debuggerSession.process");
        this.debugProcess = debugProcessImpl;
    }
}

