/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.IActivityTaskManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Singleton;
import java.util.List;

public class ActivityTaskManager {
    public static final int INVALID_STACK_ID = -1;
    public static final int INVALID_TASK_ID = -1;
    public static final int SPLIT_SCREEN_CREATE_MODE_TOP_OR_LEFT = 0;
    public static final int SPLIT_SCREEN_CREATE_MODE_BOTTOM_OR_RIGHT = 1;
    public static final int RESIZE_MODE_SYSTEM = 0;
    public static final int RESIZE_MODE_PRESERVE_WINDOW = 1;
    public static final int RESIZE_MODE_USER = 1;
    public static final int RESIZE_MODE_SYSTEM_SCREEN_ROTATION = 1;
    public static final int RESIZE_MODE_FORCED = 2;
    public static final int RESIZE_MODE_USER_FORCED = 3;
    public static final String EXTRA_PERMISSION_TOKEN = "android.app.extra.PERMISSION_TOKEN";
    public static final String EXTRA_OPTIONS = "android.app.extra.OPTIONS";
    public static final String EXTRA_IGNORE_TARGET_SECURITY = "android.app.extra.EXTRA_IGNORE_TARGET_SECURITY";
    private static int sMaxRecentTasks = -1;
    @UnsupportedAppUsage(trackingBug=129726065L)
    private static final Singleton<IActivityTaskManager> IActivityTaskManagerSingleton = new Singleton<IActivityTaskManager>(){

        @Override
        protected IActivityTaskManager create() {
            IBinder b = ServiceManager.getService("activity_task");
            return IActivityTaskManager.Stub.asInterface(b);
        }
    };

    ActivityTaskManager(Context context, Handler handler) {
    }

    public static IActivityTaskManager getService() {
        return IActivityTaskManagerSingleton.get();
    }

    public void setTaskWindowingMode(int taskId, int windowingMode, boolean toTop) throws SecurityException {
        try {
            ActivityTaskManager.getService().setTaskWindowingMode(taskId, windowingMode, toTop);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTaskWindowingModeSplitScreenPrimary(int taskId, int createMode, boolean toTop, boolean animate, Rect initialBounds, boolean showRecents) throws SecurityException {
        try {
            ActivityTaskManager.getService().setTaskWindowingModeSplitScreenPrimary(taskId, createMode, toTop, animate, initialBounds, showRecents);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resizeStack(int stackId, Rect bounds) throws SecurityException {
        try {
            ActivityTaskManager.getService().resizeStack(stackId, bounds, false, false, false, -1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeStacksInWindowingModes(int[] windowingModes) throws SecurityException {
        try {
            ActivityTaskManager.getService().removeStacksInWindowingModes(windowingModes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeStacksWithActivityTypes(int[] activityTypes) throws SecurityException {
        try {
            ActivityTaskManager.getService().removeStacksWithActivityTypes(activityTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeAllVisibleRecentTasks() {
        try {
            ActivityTaskManager.getService().removeAllVisibleRecentTasks();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int getMaxRecentTasksStatic() {
        if (sMaxRecentTasks < 0) {
            sMaxRecentTasks = ActivityManager.isLowRamDeviceStatic() ? 36 : 48;
            return sMaxRecentTasks;
        }
        return sMaxRecentTasks;
    }

    public static int getDefaultAppRecentsLimitStatic() {
        return ActivityTaskManager.getMaxRecentTasksStatic() / 6;
    }

    public static int getMaxAppRecentsLimitStatic() {
        return ActivityTaskManager.getMaxRecentTasksStatic() / 2;
    }

    public static boolean supportsMultiWindow(Context context) {
        boolean isWatch = context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        return (!ActivityManager.isLowRamDeviceStatic() || isWatch) && Resources.getSystem().getBoolean(17891539);
    }

    public static boolean supportsSplitScreenMultiWindow(Context context) {
        return ActivityTaskManager.supportsMultiWindow(context) && Resources.getSystem().getBoolean(17891541);
    }

    public boolean moveTopActivityToPinnedStack(int stackId, Rect bounds) {
        try {
            return ActivityTaskManager.getService().moveTopActivityToPinnedStack(stackId, bounds);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startSystemLockTaskMode(int taskId) {
        try {
            ActivityTaskManager.getService().startSystemLockTaskMode(taskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void stopSystemLockTaskMode() {
        try {
            ActivityTaskManager.getService().stopSystemLockTaskMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        try {
            ActivityTaskManager.getService().moveTaskToStack(taskId, stackId, toTop);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resizeStack(int stackId, Rect bounds, boolean animate) {
        try {
            ActivityTaskManager.getService().resizeStack(stackId, bounds, false, false, animate, -1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resizeTask(int taskId, Rect bounds) {
        try {
            ActivityTaskManager.getService().resizeTask(taskId, bounds, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resizeDockedStack(Rect stackBounds, Rect taskBounds) {
        try {
            ActivityTaskManager.getService().resizeDockedStack(stackBounds, taskBounds, null, null, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String listAllStacks() {
        List<ActivityManager.StackInfo> stacks;
        try {
            stacks = ActivityTaskManager.getService().getAllStackInfos();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        StringBuilder sb = new StringBuilder();
        if (stacks != null) {
            for (ActivityManager.StackInfo info : stacks) {
                sb.append(info).append("\n");
            }
        }
        return sb.toString();
    }

    public void clearLaunchParamsForPackages(List<String> packageNames) {
        try {
            ActivityTaskManager.getService().clearLaunchParamsForPackages(packageNames);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void setDisplayToSingleTaskInstance(int displayId) {
        try {
            ActivityTaskManager.getService().setDisplayToSingleTaskInstance(displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

