/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.TimestampedValue;
import java.util.Objects;

public class TimeSignal
implements Parcelable {
    public static final Parcelable.Creator<TimeSignal> CREATOR = new Parcelable.Creator<TimeSignal>(){

        @Override
        public TimeSignal createFromParcel(Parcel in) {
            return TimeSignal.createFromParcel(in);
        }

        public TimeSignal[] newArray(int size) {
            return new TimeSignal[size];
        }
    };
    public static final String SOURCE_ID_NITZ = "nitz";
    private final String mSourceId;
    private final TimestampedValue<Long> mUtcTime;

    public TimeSignal(String sourceId, TimestampedValue<Long> utcTime) {
        this.mSourceId = Objects.requireNonNull(sourceId);
        this.mUtcTime = Objects.requireNonNull(utcTime);
    }

    private static TimeSignal createFromParcel(Parcel in) {
        String sourceId = in.readString();
        TimestampedValue<Long> utcTime = TimestampedValue.readFromParcel(in, null, Long.class);
        return new TimeSignal(sourceId, utcTime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mSourceId);
        TimestampedValue.writeToParcel(dest, this.mUtcTime);
    }

    public String getSourceId() {
        return this.mSourceId;
    }

    public TimestampedValue<Long> getUtcTime() {
        return this.mUtcTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSignal that = (TimeSignal)o;
        return Objects.equals(this.mSourceId, that.mSourceId) && Objects.equals(this.mUtcTime, that.mUtcTime);
    }

    public int hashCode() {
        return Objects.hash(this.mSourceId, this.mUtcTime);
    }

    public String toString() {
        return "TimeSignal{mSourceId='" + this.mSourceId + '\'' + ", mUtcTime=" + this.mUtcTime + '}';
    }
}

